/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.importer;

import am.ik.yavi.core.ConstraintViolations;
import de.uniba.minf.registry.importer.ImportService;
import de.uniba.minf.registry.model.BaseDefinedObject;
import de.uniba.minf.registry.model.Import;
import de.uniba.minf.registry.model.ImportResult;
import de.uniba.minf.registry.model.definition.BaseDefinition;
import de.uniba.minf.registry.model.definition.EntityDefinition;
import de.uniba.minf.registry.model.entity.Entity;
import de.uniba.minf.registry.model.validation.exception.ValidationConfigurationException;
import de.uniba.minf.registry.repository.ImportRepository;
import de.uniba.minf.registry.repository.ImportResultRepository;
import de.uniba.minf.registry.service.EntityDefinitionService;
import de.uniba.minf.registry.service.EntityService;
import de.uniba.minf.registry.view.helper.EntityVocabularyHelper;
import de.uniba.minf.registry.view.helper.PropertyDefinitionHelper;
import de.uniba.minf.registry.view.model.ValidationViolationMessage;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class ImportRunner
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(ImportRunner.class);
    @Autowired
    private EntityService entityService;
    @Autowired
    private ImportService importService;
    @Autowired
    private EntityDefinitionService entityDefService;
    @Autowired
    private PropertyDefinitionHelper propertyDefinitionHelper;
    @Autowired
    private EntityVocabularyHelper entityVocabularyHelper;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private ImportResultRepository importResultRepo;
    @Autowired
    private ImportRepository importRepo;
    @Value(value="${baseUrl}")
    private String baseUrl;
    private PropertyChangeSupport support = new PropertyChangeSupport(this);
    private String importRunnerId = UUID.randomUUID().toString();
    private Locale locale;
    boolean validateOnly;
    String template;
    String format;
    String body;
    String url;
    String userId;
    String definition;
    Map<String, String> valueMap;
    ImportResult result;

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.support.addPropertyChangeListener(pcl);
    }

    @Override
    public void run() {
        try {
            this.doImport();
        }
        catch (Exception e) {
            log.error("Failed to run importer", (Throwable)e);
            this.support.firePropertyChange("error", null, e);
        }
    }

    public void doImport() throws IllegalArgumentException, MalformedURLException, IOException {
        Optional templateEntity;
        this.result = new ImportResult();
        this.result.setImportRunnerId(this.getImportRunnerId());
        List entities = this.url != null && !this.url.isBlank() ? this.entityService.readEntitiesFromURL(new URL(this.url), this.definition) : (this.format.equals("JSON") ? this.entityService.readEntitiesFromJson(this.body, this.definition) : this.entityService.readEntitiesFromYaml(this.body, this.definition));
        if (entities == null || entities.isEmpty()) {
            this.support.firePropertyChange("result", null, this.result);
            this.importResultRepo.save((Object)this.result);
            return;
        }
        if (this.template != null && (templateEntity = this.entityService.findLatestByEntityId(this.getTemplate(), true)).isPresent()) {
            for (Entity e : entities) {
                e.getProperties().addAll(((Entity)templateEntity.get()).getProperties());
            }
        }
        this.result.setEntities(entities);
        this.entityService.applyValueMappings(this.result.getEntities(), this.valueMap);
        EntityDefinition ed = this.entityDefService.findCurrentByName(this.definition, true);
        this.result.setUnknownPropertyLists(new ArrayList(this.result.getEntities().size()));
        this.result.setResolvedVocabularyEntries(new ArrayList(this.result.getEntities().size()));
        for (Entity e : this.result.getEntities()) {
            this.result.getUnknownPropertyLists().add(this.propertyDefinitionHelper.mergeWithDefinition((BaseDefinedObject)e, (BaseDefinition)ed, true));
            this.result.getResolvedVocabularyEntries().add(this.entityVocabularyHelper.resolveVocabularyEntries(e));
            this.entityService.autopopulateVocabularyData(e, ed);
        }
        this.result.setValidationMessageLists(new ArrayList(this.result.getEntities().size()));
        try {
            List violations = this.entityService.validateEntities(ed, this.result.getEntities());
            for (ConstraintViolations v : violations) {
                ArrayList validationMessages = new ArrayList();
                if (!v.isValid()) {
                    v.forEach(x -> validationMessages.add(new ValidationViolationMessage(this.convertValidationConstraintNameToViewPropertyLabel(x.name()), x.messageKey(), this.messageSource.getMessage("validation.violation." + x.messageKey(), x.args(), this.locale), x.args()[x.args().length - 1])));
                }
                this.result.getValidationMessageLists().add(validationMessages);
            }
        }
        catch (ValidationConfigurationException ex) {
            log.error("Entity validation failed with ValidationConfigurationException", (Throwable)ex);
        }
        if (!this.validateOnly) {
            this.result.setIm(this.importEntities(this.result.getEntities(), this.result.getValidationMessageLists().stream().map(vl -> !vl.isEmpty()).toList(), ed, this.template));
        }
        this.importResultRepo.save((Object)this.result);
        this.support.firePropertyChange("result", null, this.result);
    }

    public Import importEntities(List<Entity> entities, List<Boolean> isDraft, EntityDefinition ed, String templateId) {
        Import im = new Import();
        im.setTemplateId(templateId);
        im.setUserUniqueId(this.userId);
        im.setCreationInstant(Instant.now());
        this.importRepo.save((Object)im);
        for (int i = 0; i < entities.size(); ++i) {
            entities.get(i).setUserUniqueId(this.userId);
            entities.get(i).setImportId(im.getUniqueId());
            entities.get(i).setReadOnly(true);
            entities.get(i).setDraft(isDraft.get(i).booleanValue());
            this.entityService.setOrCreateRelatedEntities(entities.get(i), ed);
            this.entityService.save(entities.get(i));
        }
        return im;
    }

    private String convertValidationConstraintNameToViewPropertyLabel(String name) {
        String[] nameParts = name.split("\\.");
        StringBuilder propertyLabelBuilder = new StringBuilder();
        for (String part : nameParts) {
            if (part.startsWith("_")) continue;
            if (!propertyLabelBuilder.isEmpty()) {
                propertyLabelBuilder.append(".");
            }
            propertyLabelBuilder.append(part);
        }
        return propertyLabelBuilder.toString();
    }

    public EntityService getEntityService() {
        return this.entityService;
    }

    public ImportService getImportService() {
        return this.importService;
    }

    public EntityDefinitionService getEntityDefService() {
        return this.entityDefService;
    }

    public PropertyDefinitionHelper getPropertyDefinitionHelper() {
        return this.propertyDefinitionHelper;
    }

    public EntityVocabularyHelper getEntityVocabularyHelper() {
        return this.entityVocabularyHelper;
    }

    public MessageSource getMessageSource() {
        return this.messageSource;
    }

    public ImportResultRepository getImportResultRepo() {
        return this.importResultRepo;
    }

    public ImportRepository getImportRepo() {
        return this.importRepo;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public PropertyChangeSupport getSupport() {
        return this.support;
    }

    public String getImportRunnerId() {
        return this.importRunnerId;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public boolean isValidateOnly() {
        return this.validateOnly;
    }

    public String getTemplate() {
        return this.template;
    }

    public String getFormat() {
        return this.format;
    }

    public String getBody() {
        return this.body;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getDefinition() {
        return this.definition;
    }

    public Map<String, String> getValueMap() {
        return this.valueMap;
    }

    public ImportResult getResult() {
        return this.result;
    }

    public void setEntityService(EntityService entityService) {
        this.entityService = entityService;
    }

    public void setImportService(ImportService importService) {
        this.importService = importService;
    }

    public void setEntityDefService(EntityDefinitionService entityDefService) {
        this.entityDefService = entityDefService;
    }

    public void setPropertyDefinitionHelper(PropertyDefinitionHelper propertyDefinitionHelper) {
        this.propertyDefinitionHelper = propertyDefinitionHelper;
    }

    public void setEntityVocabularyHelper(EntityVocabularyHelper entityVocabularyHelper) {
        this.entityVocabularyHelper = entityVocabularyHelper;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public void setImportResultRepo(ImportResultRepository importResultRepo) {
        this.importResultRepo = importResultRepo;
    }

    public void setImportRepo(ImportRepository importRepo) {
        this.importRepo = importRepo;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public void setSupport(PropertyChangeSupport support) {
        this.support = support;
    }

    public void setImportRunnerId(String importRunnerId) {
        this.importRunnerId = importRunnerId;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void setValidateOnly(boolean validateOnly) {
        this.validateOnly = validateOnly;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setDefinition(String definition) {
        this.definition = definition;
    }

    public void setValueMap(Map<String, String> valueMap) {
        this.valueMap = valueMap;
    }

    public void setResult(ImportResult result) {
        this.result = result;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ImportRunner)) {
            return false;
        }
        ImportRunner other = (ImportRunner)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isValidateOnly() != other.isValidateOnly()) {
            return false;
        }
        EntityService this$entityService = this.getEntityService();
        EntityService other$entityService = other.getEntityService();
        if (this$entityService == null ? other$entityService != null : !this$entityService.equals(other$entityService)) {
            return false;
        }
        ImportService this$importService = this.getImportService();
        ImportService other$importService = other.getImportService();
        if (this$importService == null ? other$importService != null : !this$importService.equals(other$importService)) {
            return false;
        }
        EntityDefinitionService this$entityDefService = this.getEntityDefService();
        EntityDefinitionService other$entityDefService = other.getEntityDefService();
        if (this$entityDefService == null ? other$entityDefService != null : !this$entityDefService.equals(other$entityDefService)) {
            return false;
        }
        PropertyDefinitionHelper this$propertyDefinitionHelper = this.getPropertyDefinitionHelper();
        PropertyDefinitionHelper other$propertyDefinitionHelper = other.getPropertyDefinitionHelper();
        if (this$propertyDefinitionHelper == null ? other$propertyDefinitionHelper != null : !this$propertyDefinitionHelper.equals(other$propertyDefinitionHelper)) {
            return false;
        }
        EntityVocabularyHelper this$entityVocabularyHelper = this.getEntityVocabularyHelper();
        EntityVocabularyHelper other$entityVocabularyHelper = other.getEntityVocabularyHelper();
        if (this$entityVocabularyHelper == null ? other$entityVocabularyHelper != null : !this$entityVocabularyHelper.equals(other$entityVocabularyHelper)) {
            return false;
        }
        MessageSource this$messageSource = this.getMessageSource();
        MessageSource other$messageSource = other.getMessageSource();
        if (this$messageSource == null ? other$messageSource != null : !this$messageSource.equals(other$messageSource)) {
            return false;
        }
        ImportResultRepository this$importResultRepo = this.getImportResultRepo();
        ImportResultRepository other$importResultRepo = other.getImportResultRepo();
        if (this$importResultRepo == null ? other$importResultRepo != null : !this$importResultRepo.equals(other$importResultRepo)) {
            return false;
        }
        ImportRepository this$importRepo = this.getImportRepo();
        ImportRepository other$importRepo = other.getImportRepo();
        if (this$importRepo == null ? other$importRepo != null : !this$importRepo.equals(other$importRepo)) {
            return false;
        }
        String this$baseUrl = this.getBaseUrl();
        String other$baseUrl = other.getBaseUrl();
        if (this$baseUrl == null ? other$baseUrl != null : !this$baseUrl.equals(other$baseUrl)) {
            return false;
        }
        PropertyChangeSupport this$support = this.getSupport();
        PropertyChangeSupport other$support = other.getSupport();
        if (this$support == null ? other$support != null : !this$support.equals(other$support)) {
            return false;
        }
        String this$importRunnerId = this.getImportRunnerId();
        String other$importRunnerId = other.getImportRunnerId();
        if (this$importRunnerId == null ? other$importRunnerId != null : !this$importRunnerId.equals(other$importRunnerId)) {
            return false;
        }
        Locale this$locale = this.getLocale();
        Locale other$locale = other.getLocale();
        if (this$locale == null ? other$locale != null : !((Object)this$locale).equals(other$locale)) {
            return false;
        }
        String this$template = this.getTemplate();
        String other$template = other.getTemplate();
        if (this$template == null ? other$template != null : !this$template.equals(other$template)) {
            return false;
        }
        String this$format = this.getFormat();
        String other$format = other.getFormat();
        if (this$format == null ? other$format != null : !this$format.equals(other$format)) {
            return false;
        }
        String this$body = this.getBody();
        String other$body = other.getBody();
        if (this$body == null ? other$body != null : !this$body.equals(other$body)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        String this$definition = this.getDefinition();
        String other$definition = other.getDefinition();
        if (this$definition == null ? other$definition != null : !this$definition.equals(other$definition)) {
            return false;
        }
        Map this$valueMap = this.getValueMap();
        Map other$valueMap = other.getValueMap();
        if (this$valueMap == null ? other$valueMap != null : !((Object)this$valueMap).equals(other$valueMap)) {
            return false;
        }
        ImportResult this$result = this.getResult();
        ImportResult other$result = other.getResult();
        return !(this$result == null ? other$result != null : !this$result.equals(other$result));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ImportRunner;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isValidateOnly() ? 79 : 97);
        EntityService $entityService = this.getEntityService();
        result = result * 59 + ($entityService == null ? 43 : $entityService.hashCode());
        ImportService $importService = this.getImportService();
        result = result * 59 + ($importService == null ? 43 : $importService.hashCode());
        EntityDefinitionService $entityDefService = this.getEntityDefService();
        result = result * 59 + ($entityDefService == null ? 43 : $entityDefService.hashCode());
        PropertyDefinitionHelper $propertyDefinitionHelper = this.getPropertyDefinitionHelper();
        result = result * 59 + ($propertyDefinitionHelper == null ? 43 : $propertyDefinitionHelper.hashCode());
        EntityVocabularyHelper $entityVocabularyHelper = this.getEntityVocabularyHelper();
        result = result * 59 + ($entityVocabularyHelper == null ? 43 : $entityVocabularyHelper.hashCode());
        MessageSource $messageSource = this.getMessageSource();
        result = result * 59 + ($messageSource == null ? 43 : $messageSource.hashCode());
        ImportResultRepository $importResultRepo = this.getImportResultRepo();
        result = result * 59 + ($importResultRepo == null ? 43 : $importResultRepo.hashCode());
        ImportRepository $importRepo = this.getImportRepo();
        result = result * 59 + ($importRepo == null ? 43 : $importRepo.hashCode());
        String $baseUrl = this.getBaseUrl();
        result = result * 59 + ($baseUrl == null ? 43 : $baseUrl.hashCode());
        PropertyChangeSupport $support = this.getSupport();
        result = result * 59 + ($support == null ? 43 : $support.hashCode());
        String $importRunnerId = this.getImportRunnerId();
        result = result * 59 + ($importRunnerId == null ? 43 : $importRunnerId.hashCode());
        Locale $locale = this.getLocale();
        result = result * 59 + ($locale == null ? 43 : ((Object)$locale).hashCode());
        String $template = this.getTemplate();
        result = result * 59 + ($template == null ? 43 : $template.hashCode());
        String $format = this.getFormat();
        result = result * 59 + ($format == null ? 43 : $format.hashCode());
        String $body = this.getBody();
        result = result * 59 + ($body == null ? 43 : $body.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        String $definition = this.getDefinition();
        result = result * 59 + ($definition == null ? 43 : $definition.hashCode());
        Map $valueMap = this.getValueMap();
        result = result * 59 + ($valueMap == null ? 43 : ((Object)$valueMap).hashCode());
        ImportResult $result = this.getResult();
        result = result * 59 + ($result == null ? 43 : $result.hashCode());
        return result;
    }

    public String toString() {
        return "ImportRunner(entityService=" + this.getEntityService() + ", importService=" + this.getImportService() + ", entityDefService=" + this.getEntityDefService() + ", propertyDefinitionHelper=" + this.getPropertyDefinitionHelper() + ", entityVocabularyHelper=" + this.getEntityVocabularyHelper() + ", messageSource=" + this.getMessageSource() + ", importResultRepo=" + this.getImportResultRepo() + ", importRepo=" + this.getImportRepo() + ", baseUrl=" + this.getBaseUrl() + ", support=" + this.getSupport() + ", importRunnerId=" + this.getImportRunnerId() + ", locale=" + this.getLocale() + ", validateOnly=" + this.isValidateOnly() + ", template=" + this.getTemplate() + ", format=" + this.getFormat() + ", body=" + this.getBody() + ", url=" + this.getUrl() + ", userId=" + this.getUserId() + ", definition=" + this.getDefinition() + ", valueMap=" + this.getValueMap() + ", result=" + this.getResult() + ")";
    }
}

