/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.controller;

import com.fasterxml.jackson.databind.JsonNode;
import de.uniba.minf.core.rest.controller.BaseRestController;
import de.uniba.minf.core.rest.model.RestItemsResponse;
import de.uniba.minf.registry.pojo.EntityPojo;
import de.uniba.minf.registry.pojo.converter.EntityConverter;
import de.uniba.minf.registry.repository.EntityRepository;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Collection;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="Templates", description="Methods for access to entity templates")
@RestController
@RequestMapping(value={"/api/v1/templates"})
public class TemplateController
extends BaseRestController<EntityPojo> {
    private static final Logger log = LoggerFactory.getLogger(TemplateController.class);
    @Autowired
    private EntityRepository entityRepo;
    @Autowired
    private EntityConverter entityConverter;

    public TemplateController() {
        super("/api/v1/templates");
    }

    @GetMapping(value={"/"})
    public RestItemsResponse getByDefinition(HttpServletRequest request, Locale locale) {
        RestItemsResponse response = new RestItemsResponse();
        Collection entities = this.entityConverter.convertPojos(this.entityRepo.findLatestByCriteria((CriteriaDefinition)Criteria.where((String)"template").is((Object)true)));
        response.setSize((long)entities.size());
        response.setLinks((JsonNode)this.getLinks(request.getRequestURL().toString()));
        response.setItems(this.getItems(entities, request.getRequestURL().toString()));
        return response;
    }
}

