/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.controller;

import com.fasterxml.jackson.databind.JsonNode;
import de.uniba.minf.core.rest.controller.BaseRestController;
import de.uniba.minf.core.rest.model.RestItemResponse;
import de.uniba.minf.core.rest.model.RestItemsResponse;
import de.uniba.minf.core.rest.model.RestResponse;
import de.uniba.minf.registry.pojo.EntityPojo;
import de.uniba.minf.registry.pojo.converter.EntityConverter;
import de.uniba.minf.registry.repository.EntityRepository;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Collection;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="Drafts", description="Access to draft entities accessible to authenticated users")
@RestController
@RequestMapping(value={"/api/v1/drafts"})
public class DraftController
extends BaseRestController<EntityPojo> {
    private static final Logger log = LoggerFactory.getLogger(DraftController.class);
    @Autowired
    private EntityRepository entityRepo;
    @Autowired
    private EntityConverter entityConverter;

    public DraftController() {
        super("/api/v1/drafts");
    }

    @GetMapping(value={"/"})
    public RestItemsResponse getByDefinition(HttpServletRequest request, Locale locale) {
        RestItemsResponse response = new RestItemsResponse();
        Collection entities = this.entityConverter.convertPojos(this.entityRepo.findLatestByCriteria((CriteriaDefinition)Criteria.where((String)"draft").is((Object)true).and("userUniqueId").is((Object)this.authInfoHelper.getUserId())));
        response.setSize((long)entities.size());
        response.setLinks((JsonNode)this.getLinks(request.getRequestURL().toString()));
        response.setItems(this.getItems(entities, request.getRequestURL().toString()));
        return response;
    }

    @DeleteMapping
    public RestResponse deleteDrafts(HttpServletResponse resp, Locale locale) {
        Collection entities = this.entityRepo.findLatestByCriteria((CriteriaDefinition)Criteria.where((String)"draft").is((Object)true).and("userUniqueId").is((Object)this.authInfoHelper.getUserId()));
        this.entityRepo.deleteAll((Iterable)entities);
        RestItemResponse response = new RestItemResponse();
        response.setAction(RestResponse.ApiActions.DELETED);
        return response;
    }
}

