/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.view.helper;

import de.uniba.minf.registry.model.BooleanPropertyValue;
import de.uniba.minf.registry.model.Property;
import de.uniba.minf.registry.model.PropertyImpl;
import de.uniba.minf.registry.model.PropertyList;
import de.uniba.minf.registry.model.PropertyValue;
import de.uniba.minf.registry.model.PropertyValueList;
import de.uniba.minf.registry.model.TextPropertyValue;
import de.uniba.minf.registry.model.definition.EntityDefinition;
import de.uniba.minf.registry.model.definition.HierarchicalPropertyDefinition;
import de.uniba.minf.registry.model.definition.PropertyDefinition;
import de.uniba.minf.registry.model.definition.PropertyDefinitionBlock;
import de.uniba.minf.registry.model.definition.SimplePropertyDefinition;
import de.uniba.minf.registry.model.definition.VocabularyPropertyDefinition;
import de.uniba.minf.registry.model.entity.Entity;
import de.uniba.minf.registry.model.entity.EntityRelation;
import de.uniba.minf.registry.model.vocabulary.VocabularyDefinition;
import de.uniba.minf.registry.repository.EntityDefinitionRepository;
import de.uniba.minf.registry.repository.EntityRepository;
import de.uniba.minf.registry.repository.VocabularyDefinitionRepository;
import de.uniba.minf.registry.view.helper.EntityRelationsHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EntityRelationsHelper {
    @Autowired
    private EntityRepository entityRepository;
    @Autowired
    private EntityDefinitionRepository entityDefinitionRepository;
    @Autowired
    private VocabularyDefinitionRepository vocabularyDefinitionRepository;
    private static final String RELATIONS_BLOCK = "model.generic.relations";
    private static final String RELATIONS_FIELDNAME_PREFIX = "~relations";
    private static final String RELATED_ENTITY_FIELDNAME = "~relatedEntity";
    private static final String RELATION_TYPE_FIELDNAME = "~relationType";
    private static final String RELATION_INVERSE_FIELDNAME = "~relationInverse";
    private static final String RELATED_ENTITY_MESSAGECODE = "model.generic.relations.related_entity";
    private static final String RELATION_TYPE_MESSAGECODE = "model.generic.relations.relation_type";
    private static final String RELATION_INVERSE_MESSAGECODE = "model.generic.relations.inverse";

    public void appendRelationsPropertyDefinitionBlock(EntityDefinition parentEntityDefinition) {
        parentEntityDefinition.getPropertyBlocks().add(this.getRelationsPropertyDefinitionBlock(parentEntityDefinition));
    }

    private boolean isVocabularyEntryMatch(EntityRelationContainer erContainer, VocabularyPropertyDefinition vpd) {
        if (erContainer.getRelation().getTypeVocabulary() == null && vpd.getEntityRelationVocabulary() == null) {
            return true;
        }
        if (erContainer.getRelation().getTypeVocabulary() == null || vpd.getEntityRelationVocabulary() == null) {
            return false;
        }
        if (erContainer.getRelation().getTypeVocabularyKey() == null && vpd.getEntityRelationType() == null) {
            return true;
        }
        if (erContainer.getRelation().getTypeVocabularyKey() == null || vpd.getEntityRelationType() == null) {
            return false;
        }
        return erContainer.getRelation().getTypeVocabulary().equals(vpd.getEntityRelationVocabulary()) && erContainer.getRelation().getTypeVocabularyKey().equals(vpd.getEntityRelationType());
    }

    public void attachPropertiesForEntityRelations(Entity entity, EntityDefinition ed, boolean relationsToLatestOnly, Collection<EntityRelation> relations) {
        ArrayList<EntityRelationContainer> erContainers = new ArrayList<EntityRelationContainer>(relations.size());
        for (EntityRelation er : relations) {
            Entity relEntity = this.entityRepository.findById((Object)er.getRelatedUniqueIdForEntity(entity)).orElse(null);
            if (relEntity == null || relEntity.getNextVersionUniqueId() != null && relationsToLatestOnly) continue;
            EntityDefinition relEntityDef = this.entityDefinitionRepository.findCurrentByName(relEntity.getDefinitionName());
            erContainers.add(new EntityRelationContainer(this, er, relEntity, relEntityDef, er.isInverseForEntity(entity), er.getPathForEntity(entity)));
        }
        ArrayList<EntityRelationContainer> processedContainers = new ArrayList<EntityRelationContainer>();
        LinkedHashMap<String, List<String>> pathValueMap = new LinkedHashMap<String, List<String>>();
        for (Object vpd : ed.getEntityVocabularyProperties()) {
            if (vpd.getName().startsWith(RELATED_ENTITY_FIELDNAME)) continue;
            for (EntityRelationContainer erContainer : erContainers) {
                List<String> values;
                if (!vpd.getVocabulary().equals(erContainer.getRelatedEntityDefinition().getName())) continue;
                processedContainers.add(erContainer);
                if (!this.isVocabularyEntryMatch(erContainer, (VocabularyPropertyDefinition)vpd)) continue;
                if (pathValueMap.containsKey(erContainer.getPath())) {
                    values = (List)pathValueMap.get(erContainer.getPath());
                } else {
                    values = new ArrayList();
                    pathValueMap.put(erContainer.getPath(), values);
                }
                if (values.contains(erContainer.relatedEntity.getEntityId())) continue;
                values.add(erContainer.relatedEntity.getEntityId());
            }
        }
        for (Map.Entry entry : pathValueMap.entrySet()) {
            if (entry.getKey() == null) continue;
            if (((List)entry.getValue()).size() == 1) {
                entity.set((String)entry.getKey(), (String)((List)entry.getValue()).get(0), true);
                continue;
            }
            PropertyValueList lst = new PropertyValueList();
            lst.addAll(((List)entry.getValue()).stream().map(TextPropertyValue::new).toList());
            entity.set((String)entry.getKey(), (PropertyValue)lst, true);
        }
        erContainers.removeAll(processedContainers);
        LinkedHashMap<String, PropertyImpl> entityTypePropertyMap = new LinkedHashMap<String, PropertyImpl>();
        for (EntityRelationContainer erContainer : erContainers) {
            PropertyImpl pDef;
            if (entityTypePropertyMap.containsKey(erContainer.getRelatedEntityDefinition().getName())) {
                pDef = (PropertyImpl)entityTypePropertyMap.get(erContainer.getRelatedEntityDefinition().getName());
            } else {
                pDef = new PropertyImpl();
                pDef.setLabel("~relations_" + erContainer.getRelatedEntityDefinition().getName());
                pDef.setProperties(new ArrayList());
                entityTypePropertyMap.put(erContainer.getRelatedEntityDefinition().getName(), pDef);
            }
            pDef.getProperties().add(this.getPropertiesForEntityRelation(entity, erContainer.getRelatedEntity(), erContainer.isInverse(), erContainer.getRelation()));
        }
        for (Property p : entityTypePropertyMap.values()) {
            entity.add(p);
        }
    }

    public List<EntityRelation> getRelationsAndRemoveFromEntity(Entity e) {
        List relations = this.getExplicitRelationsAndRemoveFromEntity(e);
        relations.addAll(this.getImplicitRelationsAndRemoveFromEntity(e));
        return relations;
    }

    private List<EntityRelation> getImplicitRelationsAndRemoveFromEntity(Entity e) {
        ArrayList<Property> relationsProps = new ArrayList<Property>();
        for (Property p : e.getProperties()) {
            if (!p.getLabel().startsWith(RELATIONS_FIELDNAME_PREFIX)) continue;
            relationsProps.add(p);
        }
        List ers = this.createEntityRelations(e, relationsProps);
        e.getProperties().removeAll(relationsProps);
        return ers;
    }

    private List<EntityRelation> getExplicitRelationsAndRemoveFromEntity(Entity e) {
        Map explicitRelations = this.collectExplicitRelations(e.getProperties(), null);
        ArrayList<EntityRelation> ers = new ArrayList<EntityRelation>();
        if (explicitRelations.isEmpty()) {
            return ers;
        }
        for (Map.Entry entry : explicitRelations.entrySet()) {
            VocabularyPropertyDefinition vpd = ((RelationPropertyValuesContainer)entry.getValue()).getDefinition().asVocabulary();
            ((RelationPropertyValuesContainer)entry.getValue()).getValues().stream().forEach(v -> {
                EntityRelation er = this.getEntityRelation(e, v.asText(), vpd.getEntityRelationType(), vpd.getEntityRelationVocabulary(), false, null);
                if (er != null) {
                    er.setFromPath((String)entry.getKey());
                    ers.add(er);
                }
            });
        }
        return ers;
    }

    private List<EntityRelation> createEntityRelations(Entity e, List<Property> relationsProperties) {
        ArrayList<EntityRelation> ers = new ArrayList<EntityRelation>();
        for (Property p : relationsProperties) {
            for (PropertyList pl : p.getProperties()) {
                EntityRelation er = this.getEntityRelationForProperties(e, pl.getProperties());
                if (er == null) continue;
                ers.add(er);
            }
        }
        return ers;
    }

    public PropertyList getPropertiesForEntityRelation(Entity entity, Entity relEntity, boolean inverse, EntityRelation er) {
        PropertyList pl = new PropertyList();
        pl.setProperties(new ArrayList());
        PropertyImpl p = new PropertyImpl();
        p.setLabel(RELATED_ENTITY_FIELDNAME);
        p.setValue((PropertyValue)new TextPropertyValue(relEntity.getEntityId()));
        pl.add((Property)p);
        p = new PropertyImpl();
        p.setLabel(RELATION_TYPE_FIELDNAME);
        p.setValue((PropertyValue)new TextPropertyValue(er.getTypeVocabularyKey()));
        pl.add((Property)p);
        p = new PropertyImpl();
        p.setLabel(RELATION_INVERSE_FIELDNAME);
        p.setValue((PropertyValue)new BooleanPropertyValue(Boolean.valueOf(inverse)));
        pl.add((Property)p);
        return pl;
    }

    private boolean isExplicitRelation(PropertyDefinition vpd) {
        return vpd.isVocabulary() && vpd.asVocabulary().isEntity() && !vpd.getName().equals(RELATED_ENTITY_FIELDNAME);
    }

    private Map<String, RelationPropertyValuesContainer> collectExplicitRelations(List<Property> properties, String pathPrefix) {
        LinkedHashMap<String, RelationPropertyValuesContainer> relProps = new LinkedHashMap<String, RelationPropertyValuesContainer>();
        ArrayList<Property> removeProps = new ArrayList<Property>();
        for (Property p : properties) {
            String path;
            String string = path = pathPrefix == null ? p.getLabel() : pathPrefix + "." + p.getLabel();
            if (this.isExplicitRelation(p.getDefinition())) {
                ArrayList<PropertyValue> entityRelationValues = new ArrayList<PropertyValue>();
                for (PropertyValue pv : p.valuesAsList()) {
                    if (!TextPropertyValue.class.isAssignableFrom(pv.getClass()) || !((TextPropertyValue)TextPropertyValue.class.cast(pv)).isValidEntityId()) continue;
                    entityRelationValues.add(pv);
                }
                p.removeValues(entityRelationValues);
                if (p.valuesAsList().isEmpty()) {
                    removeProps.add(p);
                }
                if (entityRelationValues.isEmpty()) continue;
                relProps.put(path, new RelationPropertyValuesContainer(this, p.getDefinition(), entityRelationValues));
                continue;
            }
            if (!p.getDefinition().isHierarchical()) continue;
            relProps.putAll(this.collectExplicitRelationsForPropertyList(p.getProperties(), pathPrefix));
        }
        properties.removeAll(removeProps);
        return relProps;
    }

    private Map<String, RelationPropertyValuesContainer> collectExplicitRelationsForPropertyList(List<PropertyList> propertyLists, String pathPrefix) {
        LinkedHashMap<String, RelationPropertyValuesContainer> relProps = new LinkedHashMap<String, RelationPropertyValuesContainer>();
        int i = 0;
        for (PropertyList pl : propertyLists) {
            String path = pathPrefix + "[" + i++ + "]";
            relProps.putAll(this.collectExplicitRelations(pl.getProperties(), path));
        }
        return relProps;
    }

    public EntityRelation getEntityRelationForProperties(Entity saveEntity, List<Property> properties) {
        String entityId = null;
        String type = null;
        String vocabulary = null;
        boolean inverse = false;
        ArrayList<Property> addProperties = new ArrayList<Property>();
        for (Property p : properties) {
            if (p.getLabel().equals(RELATED_ENTITY_FIELDNAME)) {
                entityId = p.getValue().asText();
                continue;
            }
            if (p.getLabel().equals(RELATION_TYPE_FIELDNAME)) {
                type = p.getValue().asText();
                vocabulary = ((VocabularyPropertyDefinition)VocabularyPropertyDefinition.class.cast(p.getDefinition())).getVocabulary();
                continue;
            }
            if (p.getLabel().equals(RELATION_INVERSE_FIELDNAME)) {
                inverse = p.getValue().asBoolean();
                continue;
            }
            addProperties.add(p);
        }
        return this.getEntityRelation(saveEntity, entityId, type, vocabulary, inverse, addProperties);
    }

    private EntityRelation getEntityRelation(Entity saveEntity, String entityId, String type, String vocabulary, boolean inverse, List<Property> relationProperties) {
        Optional relatedEntity = this.entityRepository.findLatestByEntityId(entityId);
        if (relatedEntity.isEmpty()) {
            return null;
        }
        EntityRelation er = new EntityRelation();
        Entity fromEntity = inverse ? (Entity)relatedEntity.get() : saveEntity;
        Entity toEntity = inverse ? saveEntity : (Entity)relatedEntity.get();
        er.setFromUniqueId(fromEntity.getUniqueId());
        er.setToUniqueId(toEntity.getUniqueId());
        er.setFromEntityId(fromEntity.getEntityId());
        er.setToEntityId(toEntity.getEntityId());
        er.setMainRelationType(EntityRelation.MainRelationTypes.CUSTOM);
        er.setTypeVocabulary(vocabulary);
        er.setTypeVocabularyKey(type);
        er.setProperties(relationProperties);
        return er;
    }

    public PropertyDefinitionBlock getRelationsPropertyDefinitionBlock(EntityDefinition parentEntityDefinition) {
        PropertyDefinitionBlock relationsMetadataBlock = new PropertyDefinitionBlock();
        relationsMetadataBlock.setName(RELATIONS_BLOCK);
        relationsMetadataBlock.setIdentifier(RELATIONS_BLOCK);
        relationsMetadataBlock.setMessageCode(RELATIONS_BLOCK);
        relationsMetadataBlock.setProperties(new ArrayList());
        List<String> explicitRelations = parentEntityDefinition.getEntityVocabularyProperties().stream().filter(arg_0 -> this.isExplicitRelation(arg_0)).map(pd -> pd.getName()).toList();
        for (String relatedDefName : this.entityDefinitionRepository.findAllDefinitionNames(false)) {
            if (explicitRelations.contains(relatedDefName)) continue;
            ArrayList<String> multiList = new ArrayList<String>(1);
            multiList.add("true");
            HierarchicalPropertyDefinition relationItemDefinition = new HierarchicalPropertyDefinition();
            relationItemDefinition.setName("~relations_" + relatedDefName);
            relationItemDefinition.setIdentifier(parentEntityDefinition.getName() + "." + relationItemDefinition.getName());
            relationItemDefinition.setMessageCode("~" + relatedDefName);
            relationItemDefinition.setProperties(new ArrayList());
            relationItemDefinition.setMultiplicity(multiList);
            VocabularyPropertyDefinition adminMetadataItemDefinition = new VocabularyPropertyDefinition();
            adminMetadataItemDefinition.setName(RELATED_ENTITY_FIELDNAME);
            adminMetadataItemDefinition.setIdentifier(parentEntityDefinition.getName() + "." + adminMetadataItemDefinition.getName());
            adminMetadataItemDefinition.setMessageCode(RELATED_ENTITY_MESSAGECODE);
            adminMetadataItemDefinition.setVocabulary(relatedDefName);
            adminMetadataItemDefinition.setQuery(true);
            adminMetadataItemDefinition.setStrict(true);
            adminMetadataItemDefinition.setEntity(true);
            adminMetadataItemDefinition.setMandatory(true);
            relationItemDefinition.getProperties().add(adminMetadataItemDefinition);
            VocabularyDefinition typeVocabularyDefinition = this.vocabularyDefinitionRepository.findCurrentByName("_relations_" + parentEntityDefinition.getName() + "_" + relatedDefName);
            if (typeVocabularyDefinition == null) {
                typeVocabularyDefinition = this.vocabularyDefinitionRepository.findCurrentByName("_relations_" + relatedDefName + "_" + parentEntityDefinition.getName());
            }
            if (typeVocabularyDefinition == null) {
                typeVocabularyDefinition = this.vocabularyDefinitionRepository.findCurrentByName("_relations_" + relatedDefName);
            }
            if (typeVocabularyDefinition == null) {
                typeVocabularyDefinition = this.vocabularyDefinitionRepository.findCurrentByName("_relations");
            }
            if (typeVocabularyDefinition != null) {
                adminMetadataItemDefinition = new VocabularyPropertyDefinition();
                adminMetadataItemDefinition.setName(RELATION_TYPE_FIELDNAME);
                adminMetadataItemDefinition.setMessageCode(RELATION_TYPE_MESSAGECODE);
                adminMetadataItemDefinition.setIdentifier(parentEntityDefinition.getName() + "." + adminMetadataItemDefinition.getName());
                adminMetadataItemDefinition.setVocabulary(typeVocabularyDefinition.getName());
                adminMetadataItemDefinition.setStrict(true);
                adminMetadataItemDefinition.setMandatory(true);
                relationItemDefinition.getProperties().add(adminMetadataItemDefinition);
            }
            SimplePropertyDefinition adminMetadataItemDefinition1 = new SimplePropertyDefinition();
            adminMetadataItemDefinition1.setType(SimplePropertyDefinition.SIMPLE_TYPES.BOOLEAN);
            adminMetadataItemDefinition1.setName(RELATION_INVERSE_FIELDNAME);
            adminMetadataItemDefinition1.setMessageCode(RELATION_INVERSE_MESSAGECODE);
            adminMetadataItemDefinition1.setIdentifier(parentEntityDefinition.getName() + "." + adminMetadataItemDefinition1.getName());
            relationItemDefinition.getProperties().add(adminMetadataItemDefinition1);
            relationsMetadataBlock.getProperties().add(relationItemDefinition);
        }
        return relationsMetadataBlock;
    }
}

