/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.view.controller;

import de.uniba.minf.registry.model.IntegerPropertyValue;
import de.uniba.minf.registry.model.PersistedUser;
import de.uniba.minf.registry.model.Property;
import de.uniba.minf.registry.model.PropertyImpl;
import de.uniba.minf.registry.model.PropertyList;
import de.uniba.minf.registry.model.PropertyValue;
import de.uniba.minf.registry.model.TextPropertyValue;
import de.uniba.minf.registry.model.definition.EntityDefinition;
import de.uniba.minf.registry.model.definition.PropertyDefinition;
import de.uniba.minf.registry.model.definition.SimplePropertyDefinition;
import de.uniba.minf.registry.model.entity.Entity;
import de.uniba.minf.registry.repository.EntityRepository;
import de.uniba.minf.registry.repository.UserRepository;
import de.uniba.minf.registry.service.EntityService;
import de.uniba.minf.registry.view.controller.BaseViewController;
import de.uniba.minf.registry.view.helper.PropertyViewItemCombiner;
import de.uniba.minf.registry.view.model.PropertyBlockViewItem;
import de.uniba.minf.registry.view.model.PropertyViewItem;
import de.uniba.minf.registry.view.model.SimplePropertyViewItem;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.server.ResponseStatusException;

@Controller
@RequestMapping(value={"/entity"})
public class EntityViewController
extends BaseViewController {
    private static final Logger log = LoggerFactory.getLogger(EntityViewController.class);
    @Autowired
    private EntityRepository entityRepository;
    @Autowired
    private EntityService entityService;
    @Autowired
    private PropertyViewItemCombiner propertyViewItemCombiner;
    @Autowired
    private UserRepository userRepository;

    public EntityViewController() {
        super("entity");
    }

    @GetMapping(value={"/new/{entityDefinitionName}/"})
    public String newEntity(@PathVariable(value="entityDefinitionName") String entityDefinitionName, Model model, Locale locale) {
        EntityDefinition entityDefinition = this.entityDefinitionService.findCurrentByName(entityDefinitionName, false);
        Entity e = new Entity();
        e.setDefinitionName(entityDefinition.getName());
        e.setDefinitionVersion(entityDefinition.getVersion());
        return this.editEntity(e, entityDefinition, model, locale);
    }

    @GetMapping(value={"{uniqueId}/"})
    public String showEntity(@PathVariable(value="uniqueId") String uniqueId, Model model, Locale locale) {
        Optional entity = this.entityService.findById(uniqueId, true);
        if (!entity.isPresent()) {
            entity = this.entityService.findLatestByEntityId(uniqueId, true);
        }
        if (!entity.isPresent()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "~entity not found");
        }
        EntityDefinition entityDefinition = this.entityDefinitionService.findCurrentByName(((Entity)entity.get()).getDefinitionName(), false);
        return this.editEntity((Entity)entity.get(), entityDefinition, model, locale);
    }

    public String editEntity(Entity entity, EntityDefinition entityDefinition, Model model, Locale locale) {
        model.addAttribute("entity", (Object)entity);
        model.addAttribute("def", (Object)entityDefinition);
        List propViewItems = this.propertyViewItemCombiner.getFromDefinitionBlocksAndEntity(entityDefinition.getPropertyBlocks(), entity.getProperties());
        propViewItems.add(this.getMetadataBlock(entity, locale));
        model.addAttribute("propBlockViewItems", (Object)propViewItems);
        return "entities/edit";
    }

    @GetMapping(value={"/includes/{propertyIdentifier}"})
    public String showEntityInclude(@PathVariable(value="propertyIdentifier") String propertyIdentifier, @RequestParam(value="path") String path, Model model, Locale locale) {
        String[] propertyPath = propertyIdentifier.split("\\.");
        EntityDefinition entityDefinition = this.entityDefinitionService.findCurrentByName(propertyPath[0], false);
        PropertyDefinition propertyDefinition = entityDefinition.getDefinition(Arrays.copyOfRange(propertyPath, 1, propertyPath.length));
        PropertyList pl = new PropertyList();
        PropertyImpl p = new PropertyImpl();
        p.setProperties(new ArrayList());
        p.getProperties().add(pl);
        PropertyViewItem propViewItem = this.propertyViewItemCombiner.getFromDefinitionAndEntity(propertyDefinition, (Property)p);
        model.addAttribute("propViewItem", (Object)propViewItem);
        model.addAttribute("path", (Object)path);
        model.addAttribute("entity", (Object)new Entity());
        return "entities/async_property";
    }

    private PropertyBlockViewItem getMetadataBlock(Entity entity, Locale locale) {
        DateTimeFormatter formatter = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.LONG, FormatStyle.MEDIUM).withLocale(locale).withZone(TimeZone.getTimeZone("Europe/Berlin").toZoneId());
        PropertyBlockViewItem adminMetadataBlock = new PropertyBlockViewItem();
        adminMetadataBlock.setIdentifier("model.generic.metadata");
        adminMetadataBlock.setMessageCode("model.generic.metadata");
        ArrayList<SimplePropertyViewItem> adminMetadataItems = new ArrayList<SimplePropertyViewItem>();
        URL versionURL = null;
        URL entityURL = null;
        try {
            versionURL = new URL(this.baseUrl + "entity/" + entity.getUniqueId() + "/");
            entityURL = new URL(this.baseUrl + "entity/" + entity.getEntityId() + "/");
        }
        catch (MalformedURLException e) {
            log.error("Failed to build entity URLs", (Throwable)e);
        }
        adminMetadataItems.add(this.getMetadataItem("entity_id", (PropertyValue)new TextPropertyValue(entity.getEntityId(), null, entityURL.toString())));
        adminMetadataItems.add(this.getMetadataItem("unique_id", (PropertyValue)new TextPropertyValue(entity.getUniqueId(), null, versionURL.toString())));
        if (entity.getNextVersionUniqueId() != null) {
            adminMetadataItems.add(this.getMetadataItem("next_unique_id", (PropertyValue)new TextPropertyValue(entity.getNextVersionUniqueId(), null, entityURL.toString())));
        }
        if (entity.getCreationInstant() != null) {
            adminMetadataItems.add(this.getMetadataItem("timestamp", (PropertyValue)new TextPropertyValue(formatter.format(entity.getCreationInstant()))));
        }
        Optional user = Optional.empty();
        if (entity.getUserUniqueId() != null && (user = this.userRepository.findById((Object)entity.getUserUniqueId())).isPresent()) {
            adminMetadataItems.add(this.getMetadataItem("user", (PropertyValue)new TextPropertyValue(((PersistedUser)user.get()).getUsername())));
        }
        if (entity.getEntityId() != null) {
            int versions = (int)this.entityRepository.countVersionsByEntityId(entity.getEntityId());
            Entity initialEntity = (Entity)this.entityRepository.findEarliestByEntityId(entity.getEntityId()).get();
            adminMetadataItems.add(this.getMetadataItem("version_count", (PropertyValue)new IntegerPropertyValue(Integer.valueOf(versions))));
            if (initialEntity.getCreationInstant() != null) {
                adminMetadataItems.add(this.getMetadataItem("created_timestamp", (PropertyValue)new TextPropertyValue(formatter.format(initialEntity.getCreationInstant()))));
            }
            if (initialEntity.getUserUniqueId() != null) {
                if (entity.getUserUniqueId() == null || !initialEntity.getUserUniqueId().equals(entity.getUserUniqueId())) {
                    user = this.userRepository.findById((Object)initialEntity.getUserUniqueId());
                }
                if (user.isPresent()) {
                    adminMetadataItems.add(this.getMetadataItem("initial_user", (PropertyValue)new TextPropertyValue(((PersistedUser)user.get()).getUsername())));
                }
            }
        }
        adminMetadataBlock.setPropertyViewItems(adminMetadataItems);
        return adminMetadataBlock;
    }

    private SimplePropertyViewItem getMetadataItem(String label, PropertyValue value) {
        String code = "model.generic.metadata." + label;
        SimplePropertyDefinition adminMetadataItemDefinition = new SimplePropertyDefinition();
        adminMetadataItemDefinition.setMessageCode(code);
        adminMetadataItemDefinition.setName(label);
        adminMetadataItemDefinition.setIdentifier(code);
        adminMetadataItemDefinition.setType(SimplePropertyDefinition.SIMPLE_TYPES.TEXT);
        PropertyImpl property = new PropertyImpl();
        property.setLabel(code);
        property.setValue(value);
        SimplePropertyViewItem adminMetadataItem = new SimplePropertyViewItem((PropertyDefinition)adminMetadataItemDefinition, (Property)property);
        adminMetadataItem.setReadonly(true);
        return adminMetadataItem;
    }
}

