/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.service;

import am.ik.yavi.core.ConstraintViolations;
import am.ik.yavi.core.Validator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.uniba.minf.registry.model.BaseDefinedObject;
import de.uniba.minf.registry.model.BasePropertyValue;
import de.uniba.minf.registry.model.Property;
import de.uniba.minf.registry.model.PropertyList;
import de.uniba.minf.registry.model.PropertyValue;
import de.uniba.minf.registry.model.TextPropertyValue;
import de.uniba.minf.registry.model.definition.AutofillPropertyDefinition;
import de.uniba.minf.registry.model.definition.BaseDefinition;
import de.uniba.minf.registry.model.definition.EntityDefinition;
import de.uniba.minf.registry.model.definition.PropertyDefinition;
import de.uniba.minf.registry.model.entity.AutoqueryEntityLookupService;
import de.uniba.minf.registry.model.entity.Entity;
import de.uniba.minf.registry.model.entity.EntityRelation;
import de.uniba.minf.registry.model.validation.EntityValidator;
import de.uniba.minf.registry.model.validation.exception.ValidationConfigurationException;
import de.uniba.minf.registry.model.vocabulary.ValidationEntityService;
import de.uniba.minf.registry.model.vocabulary.VocabularyDefinition;
import de.uniba.minf.registry.model.vocabulary.VocabularyEntry;
import de.uniba.minf.registry.model.vocabulary.VocabularyLookupException;
import de.uniba.minf.registry.model.vocabulary.VocabularyLookupService;
import de.uniba.minf.registry.repository.EntityDefinitionRepository;
import de.uniba.minf.registry.repository.EntityRelationRepository;
import de.uniba.minf.registry.repository.EntityRepository;
import de.uniba.minf.registry.repository.VocabularyDefinitionRepository;
import de.uniba.minf.registry.service.EntityDefinitionService;
import de.uniba.minf.registry.service.EntityService;
import de.uniba.minf.registry.view.helper.EntityRelationsHelper;
import de.uniba.minf.registry.view.helper.PropertyDefinitionHelper;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.tika.Tika;
import org.javers.core.Javers;
import org.javers.core.diff.Diff;
import org.javers.core.diff.DiffBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.stereotype.Component;

@Component
public class EntityServiceImpl
implements EntityService {
    private static final Logger log = LoggerFactory.getLogger(EntityServiceImpl.class);
    @Autowired
    private EntityRepository entityRepo;
    @Autowired
    private EntityRelationRepository entityRelationRepo;
    @Autowired
    private EntityDefinitionService entityDefinitionService;
    @Autowired
    private EntityDefinitionRepository entityDefRepo;
    @Autowired
    private PropertyDefinitionHelper propertyDefinitionHelper;
    @Autowired
    private VocabularyLookupService vocabularyLookupService;
    @Autowired
    private VocabularyDefinitionRepository vocabularyDefinitionRepo;
    @Autowired
    private EntityRelationsHelper entityRelationsHelper;
    @Autowired
    private AutoqueryEntityLookupService entityLookupService;
    @Autowired
    private Tika tika;
    @Autowired
    @Qualifier(value="yamlMapper")
    private ObjectMapper yamlMapper;
    @Autowired
    @Qualifier(value="jsonMapper")
    private ObjectMapper jsonMapper;
    @Autowired
    private Javers javers;

    public Diff getChanges(Entity e) {
        Optional eLatest = this.findLatestByEntityId(e.getEntityId(), true);
        if (eLatest.isEmpty()) {
            return DiffBuilder.empty();
        }
        if (e.getPropertyDefinitions() != null && !e.getPropertyDefinitions().isEmpty()) {
            EntityDefinition ed = this.entityDefRepo.findCurrentByName(((Entity)eLatest.get()).getDefinitionName());
            this.propertyDefinitionHelper.mergeWithDefinition((BaseDefinedObject)eLatest.get(), (BaseDefinition)ed, true);
        }
        return this.javers.compare((Object)e.getProperties(), (Object)((Entity)eLatest.get()).getProperties());
    }

    public Optional<Entity> findById(String uniqueId, boolean loadRelations) {
        Optional e = this.entityRepo.findById((Object)uniqueId);
        if (e.isPresent() && loadRelations) {
            this.loadRelations((Entity)e.get());
        }
        return e;
    }

    public Optional<Entity> findLatestByEntityId(String entityId) {
        return this.findLatestByEntityId(entityId, false);
    }

    public Optional<Entity> findLatestByEntityId(String entityId, boolean loadRelations) {
        Optional e = this.entityRepo.findLatestByEntityId(entityId);
        if (e.isPresent() && loadRelations) {
            this.loadRelations((Entity)e.get());
        }
        return e;
    }

    public void loadRelations(Entity entity) {
        Collection relations = this.entityRelationRepo.findAllByEntityUniqueId(entity.getUniqueId());
        if (relations.isEmpty()) {
            return;
        }
        EntityDefinition ed = this.entityDefRepo.findCurrentByName(entity.getDefinitionName());
        if (entity.getPropertyDefinitions() == null) {
            this.propertyDefinitionHelper.mergeWithDefinition((BaseDefinedObject)entity, (BaseDefinition)ed, false);
        }
        this.entityRelationsHelper.attachPropertiesForEntityRelations(entity, ed, true, relations);
    }

    public Entity prepareEntity(String entityId, String definition, boolean copyAsTemplate, boolean changeToDraft, boolean changeToPublished) {
        Optional eExist;
        Entity e = new Entity();
        if (!copyAsTemplate) {
            e.setEntityId(entityId);
        }
        Optional optional = eExist = !copyAsTemplate && entityId != null ? this.entityRepo.findLatestByEntityId(entityId) : Optional.empty();
        if (eExist.isPresent()) {
            e.setDraft(((Entity)eExist.get()).isDraft());
            e.setDefinitionName(((Entity)eExist.get()).getDefinitionName());
            e.setTemplate(((Entity)eExist.get()).isTemplate());
        } else {
            e.setDefinitionName(definition);
        }
        if (copyAsTemplate || e.isTemplate()) {
            e.setTemplate(true);
            e.setDraft(false);
        } else {
            e.setDraft(!changeToPublished && (e.isDraft() || changeToDraft));
            e.setTemplate(false);
        }
        return e;
    }

    public Entity fillEntityFromDataArray(Entity e, JsonNode formData) {
        HashMap<String, TextPropertyValue> valueMap = new HashMap<String, TextPropertyValue>();
        for (JsonNode fieldNode : formData) {
            TextPropertyValue propValue;
            String name = fieldNode.get("name").asText();
            String value = fieldNode.get("value").asText();
            String prop = null;
            if (value.isEmpty() || name.startsWith("_")) continue;
            if (name.indexOf(35) >= 0) {
                prop = name.substring(name.indexOf(35) + 1);
                name = name.substring(0, name.indexOf(35));
            }
            if (valueMap.containsKey(name)) {
                propValue = (TextPropertyValue)valueMap.get(name);
            } else {
                propValue = new TextPropertyValue();
                valueMap.put(name, propValue);
            }
            if (prop != null) {
                if (!prop.equals("lang")) continue;
                propValue.setLang(value);
                continue;
            }
            propValue.setValue((Serializable)((Object)value));
        }
        for (Map.Entry v : valueMap.entrySet()) {
            e.set((String)v.getKey(), (PropertyValue)v.getValue());
        }
        return e;
    }

    public List<Entity> readEntitiesFromJson(String input, String entityDefinition) throws JsonProcessingException, IllegalArgumentException {
        JsonNode tree = this.jsonMapper.readTree(input);
        return this.readEntities(this.jsonMapper, tree, entityDefinition);
    }

    public List<Entity> readEntitiesFromYaml(String input, String entityDefinition) throws JsonProcessingException, IllegalArgumentException {
        JsonNode tree = this.yamlMapper.readTree(input);
        return this.readEntities(this.yamlMapper, tree, entityDefinition);
    }

    public List<Entity> readEntitiesFromURL(URL url, String entityDefinition) throws IllegalArgumentException, IOException {
        ObjectMapper mapper;
        String mimeType = this.tika.detect(url);
        if (mimeType != null && (mimeType.endsWith("/x-yaml") || mimeType.endsWith("/yaml"))) {
            mapper = this.yamlMapper;
        } else if (mimeType != null && mimeType.endsWith("/json")) {
            mapper = this.jsonMapper;
        } else {
            throw new IllegalArgumentException("Entity deserialization currently only supports JSON and XAML. Detected type: " + mimeType);
        }
        JsonNode tree = mapper.readTree(url);
        return this.readEntities(mapper, tree, entityDefinition);
    }

    public List<ConstraintViolations> validateEntities(EntityDefinition ed, List<Entity> entities) throws ValidationConfigurationException {
        return this.validateEntities(ed, entities, false);
    }

    public List<ConstraintViolations> validateEntities(EntityDefinition ed, List<Entity> entities, boolean skipCompleteness) throws ValidationConfigurationException {
        Validator ev = new EntityValidator(ed, this.vocabularyLookupService, this.entityLookupService, (ValidationEntityService)ValidationEntityService.class.cast(this), skipCompleteness).build();
        ArrayList<ConstraintViolations> result = new ArrayList<ConstraintViolations>();
        for (Entity e : entities) {
            result.add(this.validateEntity(ev, e));
        }
        return result;
    }

    public ConstraintViolations validateEntity(EntityDefinition ed, Entity e) throws ValidationConfigurationException {
        Validator ev = new EntityValidator(ed, this.vocabularyLookupService, this.entityLookupService, (ValidationEntityService)ValidationEntityService.class.cast(this), e.isTemplate()).build();
        return this.validateEntity(ev, e);
    }

    public ConstraintViolations validateEntity(Validator<Entity> ev, Entity e) throws ValidationConfigurationException {
        ConstraintViolations violations = ev.validate((Object)e);
        if (log.isDebugEnabled() && !violations.isValid()) {
            StringBuilder validationErrorBuilder = new StringBuilder();
            violations.forEach(x -> validationErrorBuilder.append(String.format("[%s],[%s] => %s\n", x.name(), x.messageKey(), x.message())));
            log.debug("Entity failed validation: \n{}", (Object)validationErrorBuilder.toString());
        }
        return violations;
    }

    public Entity save(Entity e) {
        List ers = this.getAndDetachEntityRelationProperties(e);
        this.entityRepo.save((Object)e);
        for (EntityRelation er : ers) {
            if (er.getFromEntityId() == null || er.getFromEntityId().equals(e.getEntityId())) {
                er.setFromUniqueId(e.getUniqueId());
                er.setFromEntityId(e.getEntityId());
            }
            if (er.getToEntityId() != null && !er.getToEntityId().equals(e.getEntityId())) continue;
            er.setToUniqueId(e.getUniqueId());
            er.setToEntityId(e.getEntityId());
        }
        this.entityRelationRepo.saveAll((Iterable)ers);
        return e;
    }

    private List<EntityRelation> getAndDetachEntityRelationProperties(Entity e) {
        if (e.getProperties() == null) {
            return new ArrayList<EntityRelation>();
        }
        if (e.getPropertyDefinitions() == null) {
            EntityDefinition ed = this.entityDefinitionService.findCurrentByName(e.getDefinitionName(), true);
            this.propertyDefinitionHelper.mergeWithDefinition((BaseDefinedObject)e, (BaseDefinition)ed, true);
        }
        return this.entityRelationsHelper.getRelationsAndRemoveFromEntity(e);
    }

    public void setOrCreateRelatedEntities(Entity e, EntityDefinition ed) {
        ed.getEntityVocabularyProperties().stream().forEach(evpd -> e.get((PropertyDefinition)evpd).stream().flatMap(p -> p.valuesAsList().stream()).forEach(pv -> {
            if (this.entityRepo.findLatestByEntityId(pv.asText()).isEmpty()) {
                EntityDefinition relEd = this.entityDefRepo.findCurrentByName(evpd.getVocabulary());
                if (relEd == null) {
                    log.warn("Queried unknown entity definition '{}'", (Object)evpd.getVocabulary());
                    return;
                }
                try {
                    if (this.entityLookupService.canResolveId(evpd.getVocabulary(), pv.asText())) {
                        Entity relE;
                        Optional matchingIdEntity = this.findByExternalIdentifier(relEd, pv.asText()).stream().findFirst();
                        if (matchingIdEntity.isPresent()) {
                            relE = (Entity)matchingIdEntity.get();
                        } else {
                            if (!relEd.hasAutoqueryProperties()) {
                                log.warn("Entity definition '{}' has no configured autoquery properties", (Object)evpd.getVocabulary());
                                return;
                            }
                            relE = this.createByAutoqueryAndAutopopulate(relEd, pv.asText());
                            this.entityRepo.save((Object)relE);
                        }
                        ((TextPropertyValue)TextPropertyValue.class.cast(pv)).setValue((Serializable)((Object)relE.getEntityId()));
                    }
                }
                catch (VocabularyLookupException ex) {
                    log.error("Failed trying to resolve vocabulary entry", (Throwable)ex);
                }
            }
        }));
    }

    public Collection<Entity> findByExternalIdentifier(EntityDefinition ed, String identifier) {
        List idProps = ed.getExternalIdentifierProperties();
        if (idProps.isEmpty()) {
            return new ArrayList<Entity>(0);
        }
        Criteria[] identifierCriteria = new Criteria[idProps.size()];
        for (int i = 0; i < idProps.size(); ++i) {
            String[] pathWithEntity = ((PropertyDefinition)idProps.get(i)).getIdentifier().split("\\.");
            Criteria c = null;
            for (int j = pathWithEntity.length - 1; j >= 1; --j) {
                c = j == pathWithEntity.length - 1 ? new Criteria().andOperator(new Criteria[]{Criteria.where((String)"label").is((Object)pathWithEntity[j]), new Criteria().orOperator(new Criteria[]{Criteria.where((String)"value.value").is((Object)identifier), Criteria.where((String)"values").elemMatch(Criteria.where((String)"value").is((Object)identifier))})}) : Criteria.where((String)"label").is((Object)pathWithEntity[j]).and("properties").elemMatch(Criteria.where((String)"properties").elemMatch(c));
            }
            identifierCriteria[i] = c = Criteria.where((String)"properties").elemMatch(c);
        }
        Criteria cr = new Criteria().andOperator(new Criteria[]{Criteria.where((String)"definitionName").is((Object)ed.getName()), new Criteria().orOperator(identifierCriteria)});
        return this.entityRepo.findLatestByCriteria((CriteriaDefinition)cr);
    }

    public Collection<Entity> findByExternalIdentifier(String definition, String identifier) {
        EntityDefinition ed = this.entityDefRepo.findCurrentByName(definition);
        if (ed == null) {
            return new ArrayList<Entity>(0);
        }
        return this.findByExternalIdentifier(ed, identifier);
    }

    private Entity createByAutoqueryAndAutopopulate(EntityDefinition ed, String key) {
        Entity e = new Entity();
        ed.getAutoqueryProperties().stream().forEach(aqPropertyDefinition -> {
            String path = aqPropertyDefinition.getIdentifier().substring(aqPropertyDefinition.getIdentifier().indexOf(46) + 1);
            e.set(path, key);
        });
        this.propertyDefinitionHelper.mergeWithDefinition((BaseDefinedObject)e, (BaseDefinition)ed, false);
        this.autopopulateVocabularyData(e, ed);
        return e;
    }

    public List<Entity> createEntitiesByAutoquery(String definition, String query) {
        ArrayList<Entity> result = new ArrayList<Entity>();
        try {
            List ves = this.entityLookupService.search(definition, query);
            EntityDefinition ed = this.entityDefRepo.findCurrentByName(definition);
            if (ed == null) {
                log.warn("Queried unknown entity definition '{}'", (Object)definition);
                return result;
            }
            if (!ed.hasAutoqueryProperties()) {
                log.warn("Entity definition '{}' has no configured autoquery properties", (Object)definition);
                return result;
            }
            ves.stream().forEach(ve -> {
                Entity e = this.createByAutoqueryAndAutopopulate(ed, ve.getKey());
                e.setEntityId(ve.getKey());
                result.add(e);
            });
        }
        catch (VocabularyLookupException e) {
            log.error("Failed to autoquery entities", (Throwable)e);
        }
        return result;
    }

    public void autopopulateVocabularyData(Entity e, EntityDefinition ed) {
        ed.getAutofillProperties().stream().forEach(afPropertyDefinition -> {
            String[] path = afPropertyDefinition.getIdentifier().split("\\.");
            Property vocabularyProp = e.get(Arrays.copyOfRange(path, 1, path.length));
            if (!vocabularyProp.isMissing()) {
                vocabularyProp.valuesAsList().stream().forEach(vocabularyPropVal -> {
                    try {
                        VocabularyEntry ve = this.vocabularyLookupService.resolve(afPropertyDefinition.getVocabulary(), vocabularyPropVal.asText());
                        if (ve != null) {
                            VocabularyDefinition vd = this.vocabularyDefinitionRepo.findCurrentByName(afPropertyDefinition.getVocabulary());
                            this.propertyDefinitionHelper.mergeWithDefinition((BaseDefinedObject)ve, (BaseDefinition)vd, true);
                            this.mergeAutofillProperties(e, ve.getProperties(), null, afPropertyDefinition.isAutofillAll() ? null : afPropertyDefinition.getAutofillProperties(), vd.getName());
                        }
                    }
                    catch (VocabularyLookupException e1) {
                        log.error("Failed to resolve autofill property", (Object)e);
                    }
                });
            }
        });
    }

    public void applyValueMappings(List<Entity> entities, Map<String, String> valueMap) {
        entities.stream().forEach(e -> this.applyValueMappingsToProperties(e.getProperties(), valueMap));
    }

    public void applyValueMappings(Entity entity, Map<String, String> valueMap) {
        this.applyValueMappingsToProperties(entity.getProperties(), valueMap);
    }

    public void addAllNotContainingIdentifier(EntityDefinition ed, Collection<Entity> target, Collection<Entity> additions) {
        target.addAll(additions);
    }

    private void applyValueMappingsToProperties(List<Property> properties, Map<String, String> valueMap) {
        properties.stream().forEach(p -> {
            p.valuesAsList().stream().filter(v -> TextPropertyValue.class.isAssignableFrom(v.getClass()) && valueMap.containsKey(v.asText())).forEach(v -> ((TextPropertyValue)TextPropertyValue.class.cast(v)).setValue((Serializable)((Object)((String)valueMap.get(v.asText())))));
            if (p.getProperties() != null) {
                this.applyValueMappingsToPropertyLists(p.getProperties(), valueMap);
            }
        });
    }

    private void applyValueMappingsToPropertyLists(List<PropertyList> propertyLists, Map<String, String> valueMap) {
        propertyLists.stream().forEach(pl -> this.applyValueMappingsToProperties(pl.getProperties(), valueMap));
    }

    private List<Entity> readEntities(ObjectMapper mapper, JsonNode tree, String entityDefinition) throws JsonProcessingException, IllegalArgumentException {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        if (!tree.isArray() && tree.has("_links") && (tree.has("items") || tree.has("item"))) {
            JsonNode jsonNode = tree = tree.has("items") ? tree.get("items") : tree.get("item");
        }
        if (tree.isArray()) {
            for (JsonNode n : tree) {
                entities.add(this.readEntity(mapper, n, entityDefinition));
            }
        } else {
            entities.add(this.readEntity(mapper, tree, entityDefinition));
        }
        return entities;
    }

    private Entity readEntity(ObjectMapper mapper, JsonNode n, String entityDefinition) throws JsonProcessingException, IllegalArgumentException {
        if (n.has(entityDefinition) && n.size() == 1) {
            n = n.get(entityDefinition);
        }
        if (n.isObject() && !n.has("_entity")) {
            ((ObjectNode)ObjectNode.class.cast(n)).put("_entity", entityDefinition);
        }
        return (Entity)mapper.treeToValue((TreeNode)n, Entity.class);
    }

    private void mergeAutofillProperties(Entity target, List<Property> properties, String pathPrefix, List<AutofillPropertyDefinition> propertyFilter, String vocabularyName) {
        for (Property mergeP : properties) {
            Object subPath;
            if (mergeP.getDefinition() == null) continue;
            String filterIdentifier = mergeP.getDefinition().getIdentifier().substring(mergeP.getDefinition().getIdentifier().indexOf(46) + 1);
            if (mergeP.getDefinition().isHierarchical()) {
                subPath = pathPrefix == null ? mergeP.getLabel() : pathPrefix + "." + mergeP.getLabel();
                this.mergeAutofillPropertyLists(target, mergeP.getProperties(), (String)subPath, propertyFilter, vocabularyName);
                continue;
            }
            if (propertyFilter == null) {
                subPath = pathPrefix == null ? mergeP.getLabel() : pathPrefix + "." + mergeP.getLabel();
            } else {
                if (!propertyFilter.stream().anyMatch(p -> p.filterApplies(filterIdentifier))) continue;
                AutofillPropertyDefinition propDef = propertyFilter.stream().filter(p -> p.filterApplies(filterIdentifier)).findFirst().orElse(null);
                subPath = propDef.getExternalName() != null ? (pathPrefix == null ? propDef.getPropertyName() : pathPrefix + "." + propDef.getPropertyName()) : (pathPrefix == null ? mergeP.getLabel() : pathPrefix + "." + mergeP.getLabel());
            }
            PropertyValue p2 = mergeP.getValue();
            if (p2.isMultivalue()) {
                p2.valuesAsList().stream().forEach(v -> ((BasePropertyValue)BasePropertyValue.class.cast(v)).setSource(vocabularyName));
            } else {
                ((BasePropertyValue)BasePropertyValue.class.cast(p2)).setSource(vocabularyName);
            }
            target.set((String)subPath, mergeP.getValue());
        }
    }

    private void mergeAutofillPropertyLists(Entity target, List<PropertyList> propertyLists, String pathPrefix, List<AutofillPropertyDefinition> propertyFilter, String vocabularyName) {
        for (int i = 0; i < propertyLists.size(); ++i) {
            this.mergeAutofillProperties(target, propertyLists.get(i).getProperties(), pathPrefix + "[" + i + "]", propertyFilter, vocabularyName);
        }
    }
}

