/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.repository;

import de.uniba.minf.registry.model.vocabulary.VocabularyDefinition;
import de.uniba.minf.registry.repository.VocabularyDefinitionRepositoryCustom;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;

public class VocabularyDefinitionRepositoryCustomImpl
implements VocabularyDefinitionRepositoryCustom {
    @Autowired
    private MongoTemplate mongoTemplate;

    public List<String> findAllDefinitionNames() {
        return this.mongoTemplate.findDistinct("name", VocabularyDefinition.class, String.class);
    }

    public Collection<VocabularyDefinition> findAllLatest() {
        return this.findLatestByCriteria(null);
    }

    public VocabularyDefinition findCurrentByName(String name) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"name").is((Object)name));
        query.with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"creationInstant"}));
        return (VocabularyDefinition)this.mongoTemplate.findOne(query, VocabularyDefinition.class);
    }

    public Collection<VocabularyDefinition> findLatestByCriteria(CriteriaDefinition criteria) {
        Query query = new Query();
        if (criteria != null) {
            query.addCriteria(criteria);
        }
        query.with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"creationInstant"}));
        HashMap result = new HashMap();
        this.mongoTemplate.find(query, VocabularyDefinition.class).stream().forEach(e -> {
            if (!result.containsKey(e.getName())) {
                result.put(e.getName(), e);
            }
        });
        return result.values();
    }
}

