/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.model;

import de.uniba.minf.core.rest.model.Identifiable;
import jakarta.validation.constraints.Pattern;
import org.springframework.data.annotation.Id;

public class VersionInfo
implements Identifiable,
Comparable<VersionInfo> {
    private static final long serialVersionUID = -6247839976852400057L;
    @Id
    private String uniqueId;
    @Pattern(regexp="^\\d+(\\.\\d+)?(\\.\\d+)?$")
    private @Pattern(regexp="^\\d+(\\.\\d+)?(\\.\\d+)?$") String version;
    private String versionHash;
    private String note;
    private boolean updateWithErrors;

    @Override
    public int compareTo(VersionInfo oComp) {
        String[] versionArr = this.version.split("\\.");
        String[] compVersionArr = oComp.getVersion().split("\\.");
        for (int i = 0; i < versionArr.length || i < compVersionArr.length; ++i) {
            if (i == versionArr.length) {
                return -1;
            }
            if (i == compVersionArr.length) {
                return 1;
            }
            int majorMinorComp = Integer.valueOf(versionArr[i]).compareTo(Integer.valueOf(compVersionArr[i]));
            if (majorMinorComp == 0) continue;
            return majorMinorComp;
        }
        return 0;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getVersionHash() {
        return this.versionHash;
    }

    public String getNote() {
        return this.note;
    }

    public boolean isUpdateWithErrors() {
        return this.updateWithErrors;
    }

    public void setUniqueId(String uniqueId) {
        this.uniqueId = uniqueId;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setVersionHash(String versionHash) {
        this.versionHash = versionHash;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public void setUpdateWithErrors(boolean updateWithErrors) {
        this.updateWithErrors = updateWithErrors;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VersionInfo)) {
            return false;
        }
        VersionInfo other = (VersionInfo)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isUpdateWithErrors() != other.isUpdateWithErrors()) {
            return false;
        }
        String this$uniqueId = this.getUniqueId();
        String other$uniqueId = other.getUniqueId();
        if (this$uniqueId == null ? other$uniqueId != null : !this$uniqueId.equals(other$uniqueId)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$versionHash = this.getVersionHash();
        String other$versionHash = other.getVersionHash();
        if (this$versionHash == null ? other$versionHash != null : !this$versionHash.equals(other$versionHash)) {
            return false;
        }
        String this$note = this.getNote();
        String other$note = other.getNote();
        return !(this$note == null ? other$note != null : !this$note.equals(other$note));
    }

    protected boolean canEqual(Object other) {
        return other instanceof VersionInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isUpdateWithErrors() ? 79 : 97);
        String $uniqueId = this.getUniqueId();
        result = result * 59 + ($uniqueId == null ? 43 : $uniqueId.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $versionHash = this.getVersionHash();
        result = result * 59 + ($versionHash == null ? 43 : $versionHash.hashCode());
        String $note = this.getNote();
        result = result * 59 + ($note == null ? 43 : $note.hashCode());
        return result;
    }

    public String toString() {
        return "VersionInfo(uniqueId=" + this.getUniqueId() + ", version=" + this.getVersion() + ", versionHash=" + this.getVersionHash() + ", note=" + this.getNote() + ", updateWithErrors=" + this.isUpdateWithErrors() + ")";
    }
}

