/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.controller;

import am.ik.yavi.core.ConstraintViolations;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.uniba.minf.core.rest.controller.BaseRestController;
import de.uniba.minf.core.rest.exception.ApiExecutionException;
import de.uniba.minf.core.rest.exception.ApiItemNotFoundException;
import de.uniba.minf.core.rest.model.ErrorRestResponse;
import de.uniba.minf.core.rest.model.Identifiable;
import de.uniba.minf.core.rest.model.RestActionResponse;
import de.uniba.minf.core.rest.model.RestItemResponse;
import de.uniba.minf.core.rest.model.RestItemsResponse;
import de.uniba.minf.core.rest.model.RestResponse;
import de.uniba.minf.registry.importer.ImportRunner;
import de.uniba.minf.registry.importer.ImportService;
import de.uniba.minf.registry.model.BaseDefinedObject;
import de.uniba.minf.registry.model.definition.BaseDefinition;
import de.uniba.minf.registry.model.definition.EntityDefinition;
import de.uniba.minf.registry.model.entity.Entity;
import de.uniba.minf.registry.model.validation.exception.ValidationConfigurationException;
import de.uniba.minf.registry.repository.EntityDefinitionRepository;
import de.uniba.minf.registry.repository.EntityRepository;
import de.uniba.minf.registry.service.EntityDefinitionService;
import de.uniba.minf.registry.service.EntityService;
import de.uniba.minf.registry.view.helper.EntityVocabularyHelper;
import de.uniba.minf.registry.view.helper.PropertyDefinitionHelper;
import de.uniba.minf.registry.view.helper.PropertyPreviewHelper;
import de.uniba.minf.registry.view.model.ValidationViolationMessage;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.javers.core.diff.Diff;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="Entities", description="Methods for reading and writing entities.")
@RestController
@RequestMapping(value={"/api/v1/e"})
public class EntityController
extends BaseRestController<Entity>
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(EntityController.class);
    @Autowired
    private EntityRepository entityRepo;
    @Autowired
    private EntityDefinitionRepository entityDefRepo;
    @Autowired
    private EntityDefinitionService entityDefService;
    @Autowired
    private PropertyDefinitionHelper propertyDefinitionHelper;
    @Autowired
    private EntityVocabularyHelper entityVocabularyHelper;
    @Autowired
    private EntityService entityService;
    @Autowired
    private ImportService importService;
    private ApplicationContext appContext;

    public EntityController() {
        super("/api/v1/e");
    }

    public void setApplicationContext(ApplicationContext appContext) throws BeansException {
        this.appContext = appContext;
    }

    @GetMapping
    public RestItemsResponse get(HttpServletRequest request, Locale locale) {
        RestItemsResponse response = new RestItemsResponse();
        List entities = this.entityRepo.findAll();
        response.setSize((long)entities.size());
        response.setLinks((JsonNode)this.getLinks(request.getRequestURL().toString()));
        response.setItems(this.getItems((Collection)entities, request.getRequestURL().toString()));
        return response;
    }

    @GetMapping(value={"/{id}"})
    public Entity get(@PathVariable(value="id") String id, Locale locale) {
        Optional entity = this.entityRepo.findLatestByEntityId(id);
        if (entity.isPresent()) {
            return (Entity)entity.get();
        }
        return this.entityRepo.findById((Object)id).orElse(null);
    }

    @GetMapping(value={"/{name}/"})
    public RestItemsResponse getByDefinition(@PathVariable(value="name") String name, HttpServletRequest request, Locale locale) {
        RestItemsResponse response = new RestItemsResponse();
        Collection entities = this.entityRepo.findLatestByDefinition(name);
        response.setSize((long)entities.size());
        response.setLinks((JsonNode)this.getLinks(request.getRequestURL().toString()));
        response.setItems(this.getItems(entities, request.getRequestURL().toString()));
        return response;
    }

    @GetMapping(value={"/i/{importId}/"})
    public RestItemsResponse getByImportId(@PathVariable(value="importId") String importId, HttpServletRequest request, Locale locale) {
        RestItemsResponse response = new RestItemsResponse();
        Collection entities = this.entityRepo.findByImportId(importId);
        response.setSize((long)entities.size());
        response.setLinks((JsonNode)this.getLinks(request.getRequestURL().toString()));
        response.setItems(this.getItems(entities, request.getRequestURL().toString()));
        return response;
    }

    @PostMapping(value={"/{name}/search"})
    public RestItemsResponse searchEntries(@PathVariable(value="name") String name, @RequestBody(required=false) JsonNode body, HttpServletRequest request, Locale locale) throws ApiExecutionException {
        RestItemsResponse response = new RestItemsResponse();
        if (body == null || !body.has("query") || body.get("query").asText().isEmpty()) {
            throw new ApiExecutionException("No query provided");
        }
        EntityDefinition ed = this.entityDefRepo.findCurrentByName(name);
        ArrayList entities = new ArrayList();
        this.entityService.addAllNotContainingIdentifier(ed, entities, this.entityRepo.findLatestByDefinitionAndQuery(name, body.get("query").asText()));
        if (ed.hasAutoqueryProperties()) {
            this.entityService.addAllNotContainingIdentifier(ed, entities, (Collection)this.entityService.createEntitiesByAutoquery(name, body.get("query").asText()));
        }
        response.setSize((long)entities.size());
        response.setLinks((JsonNode)this.getLinks(request.getRequestURL().toString()));
        response.setItems(this.getItems(entities, request.getRequestURL().toString(), ed, body.has("ui") && body.get("ui").asBoolean()));
        return response;
    }

    @PostMapping(value={"/{name}/get"})
    public RestItemResponse getEntry(@PathVariable(value="name") String name, @RequestBody(required=false) JsonNode body, HttpServletRequest request, Locale locale) throws ApiItemNotFoundException, ApiExecutionException {
        RestItemResponse response = new RestItemResponse();
        String entityId = null;
        String uniqueId = null;
        if (body != null && body.has("entityId") && !body.get("entityId").asText().isEmpty()) {
            entityId = body.get("entityId").asText();
        } else if (body != null && body.has("uniqueId") && !body.get("uniqueId").asText().isEmpty()) {
            uniqueId = body.get("uniqueId").asText();
        } else {
            throw new ApiExecutionException("Neither EntityId or UniqueId provided");
        }
        Optional entity = entityId != null ? this.entityRepo.findLatestByEntityId(entityId) : this.entityRepo.findById((Object)uniqueId);
        if (entity.isEmpty()) {
            throw new ApiItemNotFoundException("entity", entityId == null ? uniqueId : entityId);
        }
        EntityDefinition ed = this.entityDefRepo.findCurrentByName(name);
        response.setLinks((JsonNode)this.getLinks(request.getRequestURL().toString()));
        response.setItem((JsonNode)this.getItem((Entity)entity.get(), request.getRequestURL().toString(), true, ed, body.has("ui") && body.get("ui").asBoolean()));
        return response;
    }

    @PostMapping(value={"/{name}/validate"}, consumes={"application/json"})
    public RestResponse validateEntities(@PathVariable(value="name") String name, @RequestBody String body, HttpServletRequest req, HttpServletResponse resp, Locale locale) throws JsonProcessingException, ValidationConfigurationException {
        return this.validateOrImportEntities(name, body, req, resp, locale, true);
    }

    @PostMapping(value={"/{name}/import"}, consumes={"application/json"})
    public RestResponse importEntities(@PathVariable(value="name") String name, @RequestBody String body, HttpServletRequest req, HttpServletResponse resp, Locale locale) throws ValidationConfigurationException, JsonMappingException, JsonProcessingException {
        return this.validateOrImportEntities(name, body, req, resp, locale, false);
    }

    @PostMapping(value={"/", "/{entityId}"}, consumes={"application/json"})
    public RestResponse postEntityForm(@PathVariable(required=false, value="entityId") String entityId, @RequestBody JsonNode formData, HttpServletRequest req, HttpServletResponse resp, Locale locale) throws ValidationConfigurationException {
        boolean validateOnly = req.getHeader("Entity-Validate-Only") != null && req.getHeader("Entity-Validate-Only").equals("true");
        boolean changeToDraft = req.getHeader("Entity-Save-Draft") != null && req.getHeader("Entity-Save-Draft").equals("true");
        boolean changeToPublished = req.getHeader("Entity-Save-Published") != null && req.getHeader("Entity-Save-Published").equals("true");
        boolean copyAsTemplate = req.getHeader("Entity-Save-Template") != null && req.getHeader("Entity-Save-Template").equals("true");
        Entity e = this.entityService.prepareEntity(entityId, this.getEntityDefinitionFromDataArray(formData), copyAsTemplate, changeToDraft, changeToPublished);
        EntityDefinition ed = this.entityDefService.findCurrentByName(e.getDefinitionName(), true);
        this.propertyDefinitionHelper.mergeWithDefinition((BaseDefinedObject)e, (BaseDefinition)ed, false);
        this.entityService.fillEntityFromDataArray(e, formData);
        this.entityService.autopopulateVocabularyData(e, ed);
        if (validateOnly || e.isPublished()) {
            try {
                ConstraintViolations violations = this.entityService.validateEntity(ed, e);
                if (!violations.isValid()) {
                    return this.buildValidationFailedResponse(violations, req, resp, locale);
                }
                if (validateOnly) {
                    return this.buildItemResponse(RestResponse.ApiActions.VALIDATED, e);
                }
                e.setValid(violations.isValid());
            }
            catch (ValidationConfigurationException e1) {
                log.error("Entity validation failed with ValidationConfigurationException", (Throwable)e1);
                throw e1;
            }
        }
        this.propertyDefinitionHelper.mergeWithDefinition((BaseDefinedObject)e, (BaseDefinition)ed, true);
        this.entityService.setOrCreateRelatedEntities(e, ed);
        if (e.getEntityId() == null && e.getProperties() != null && !e.getProperties().isEmpty()) {
            return this.buildItemResponse(RestResponse.ApiActions.CREATED, this.entityService.save(e));
        }
        if (e.getEntityId() == null) {
            return this.buildItemResponse(RestResponse.ApiActions.UNCHANGED, e);
        }
        Diff diff = this.entityService.getChanges(e);
        if (e.getProperties() != null && !e.getProperties().isEmpty() && (diff.hasChanges() || changeToDraft || changeToPublished)) {
            return this.buildItemResponse(RestResponse.ApiActions.UPDATED, this.entityService.save(e));
        }
        return this.buildItemResponse(RestResponse.ApiActions.UNCHANGED, e);
    }

    @DeleteMapping(value={"/{entityId}"})
    public RestResponse deleteEntity(@PathVariable(required=false, value="entityId") String entityId, HttpServletResponse resp, Locale locale) {
        Optional eExist = this.entityRepo.findLatestByEntityId(entityId);
        if (eExist.isPresent()) {
            ((Entity)eExist.get()).setDeleted(true);
            this.entityRepo.save((Object)((Entity)eExist.get()));
        }
        log.debug(entityId);
        RestItemResponse response = new RestItemResponse();
        response.setAction(RestResponse.ApiActions.DELETED);
        return response;
    }

    @GetMapping(value={"/{name}/validate/{importId}", "/{name}/import/{importId}"})
    public RestResponse validateEntities(@PathVariable(value="name") String name, @PathVariable(value="importId") String importId, HttpServletRequest req) {
        return new RestActionResponse(RestActionResponse.ApiActionStatus.BUSY, req.getRequestURI());
    }

    private RestResponse validateOrImportEntities(String name, String envelope, HttpServletRequest req, HttpServletResponse resp, Locale locale, boolean validateOnly) throws JsonMappingException, JsonProcessingException {
        JsonNode n = this.objectMapper.readTree(envelope);
        boolean readonly = !n.has("importType") || !n.get("importType").asText().equals("full");
        String template = n.has("template") && !n.get("template").asText().isBlank() ? n.get("template").asText() : null;
        String format = n.has("format") && n.get("format").asText().equals("yaml") ? "YAML" : "JSON";
        String body = n.has("data") ? n.get("data").asText() : null;
        String url = n.has("importUrl") ? n.get("importUrl").asText() : null;
        HashMap<String, String> valueMap = new HashMap<String, String>();
        if (n.has("mappings")) {
            for (JsonNode nM : n.get("mappings")) {
                if (!nM.isArray() || nM.size() < 2) continue;
                valueMap.put(nM.get(0).asText(), nM.get(1).asText());
            }
        }
        if (url != null && !url.isBlank()) {
            try {
                URL u = new URL(url);
                HttpURLConnection huc = (HttpURLConnection)u.openConnection();
                huc.setRequestMethod("HEAD");
                huc.setInstanceFollowRedirects(true);
                huc.connect();
                int code = huc.getResponseCode();
                if (code < 200 || code > 400) {
                    return this.buildFailedWithExceptionResponse(HttpStatus.valueOf((int)code), this.messageSource.getMessage("view.import.messages.url_invalid", null, locale), null, req, resp, locale);
                }
            }
            catch (MalformedURLException e) {
                return this.buildFailedWithExceptionResponse("import-data-url", "import-data-url", this.messageSource.getMessage("view.import.messages.url_invalid", null, locale), (Exception)e, req, resp, locale);
            }
            catch (IOException e) {
                return this.buildFailedWithExceptionResponse(HttpStatus.BAD_REQUEST, this.messageSource.getMessage("view.import.messages.url_invalid", null, locale) + ": " + e.getLocalizedMessage(), null, req, resp, locale);
            }
        }
        ImportRunner ir = (ImportRunner)this.appContext.getBean(ImportRunner.class);
        ir.setUrl(url);
        ir.setFormat(format);
        ir.setBody(body);
        ir.setReadonly(readonly);
        ir.setValidateOnly(validateOnly);
        ir.setTemplate(template);
        ir.setValueMap(valueMap);
        ir.setDefinition(name);
        this.importService.importAsync(ir);
        return new RestActionResponse(RestActionResponse.ApiActionStatus.STARTED, req.getRequestURI() + "/" + ir.getImportRunnerId());
    }

    private String getEntityDefinitionFromDataArray(JsonNode formData) {
        for (JsonNode fieldNode : formData) {
            if (!fieldNode.get("name").asText().equals("_entity")) continue;
            return fieldNode.get("value").asText();
        }
        return null;
    }

    private RestItemResponse buildItemResponse(RestResponse.ApiActions action, Entity e) {
        RestItemResponse response = new RestItemResponse();
        response.setAction(action);
        response.setItem(this.objectMapper.valueToTree((Object)e));
        return response;
    }

    private ErrorRestResponse buildValidationFailedResponse(ConstraintViolations violations, HttpServletRequest req, HttpServletResponse resp, Locale locale) {
        ErrorRestResponse response = new ErrorRestResponse(HttpStatus.BAD_REQUEST.value(), this.messageSource.getMessage("view.import.messages.validation_result_invalid", null, locale), req.getRequestURL().toString());
        ArrayList validationMessages = new ArrayList();
        violations.forEach(x -> validationMessages.add(new ValidationViolationMessage(this.convertValidationConstraintNameToViewPropertyLabel(x.name()), x.messageKey(), this.messageSource.getMessage("validation.violation." + x.messageKey(), x.args(), locale))));
        response.setErrorDetails(this.objectMapper.valueToTree(validationMessages));
        resp.setStatus(HttpStatus.BAD_REQUEST.value());
        return response;
    }

    private ErrorRestResponse buildFailedWithExceptionResponse(HttpStatus code, String message, Exception ex, HttpServletRequest req, HttpServletResponse resp, Locale locale) {
        return this.buildFailedWithExceptionResponse(code, null, null, message, ex, req, resp, locale);
    }

    private ErrorRestResponse buildFailedWithExceptionResponse(String name, String key, String message, Exception ex, HttpServletRequest req, HttpServletResponse resp, Locale locale) {
        return this.buildFailedWithExceptionResponse(HttpStatus.BAD_REQUEST, name, key, message, ex, req, resp, locale);
    }

    private ErrorRestResponse buildFailedWithExceptionResponse(HttpStatus code, String name, String key, String message, Exception ex, HttpServletRequest req, HttpServletResponse resp, Locale locale) {
        ErrorRestResponse response = new ErrorRestResponse(code.value(), message, req.getRequestURL().toString());
        if (name != null || key != null) {
            ArrayList<ValidationViolationMessage> validationMessages = new ArrayList<ValidationViolationMessage>();
            validationMessages.add(new ValidationViolationMessage(name, key, ex == null ? this.messageSource.getMessage("view.import.messages.generic_exception", null, locale) : ex.getLocalizedMessage()));
            response.setErrorDetails(this.objectMapper.valueToTree(validationMessages));
        }
        resp.setStatus(code.value());
        return response;
    }

    private String convertValidationConstraintNameToViewPropertyLabel(String name) {
        String[] nameParts = name.split("\\.");
        StringBuilder propertyLabelBuilder = new StringBuilder();
        for (String part : nameParts) {
            if (part.startsWith("_")) continue;
            if (!propertyLabelBuilder.isEmpty()) {
                propertyLabelBuilder.append(".");
            }
            propertyLabelBuilder.append(part);
        }
        return propertyLabelBuilder.toString();
    }

    private ArrayNode getItems(Collection<Entity> items, String requestUrl, EntityDefinition ed, boolean addViewItems) {
        ArrayNode array = this.objectMapper.createArrayNode();
        if (items != null) {
            for (Entity rec : items) {
                array.add((JsonNode)this.getItem(rec, requestUrl, true, ed, addViewItems));
            }
        }
        return array;
    }

    private ObjectNode getItem(Entity item, String requestUrl, boolean suffixUniqueId, EntityDefinition ed, boolean addViewItems) {
        ObjectNode recNode = (ObjectNode)this.objectMapper.valueToTree((Object)item);
        if (addViewItems) {
            recNode.set("_view", this.objectMapper.valueToTree((Object)PropertyPreviewHelper.get().extractSubproperties(ed.getPreviewProperties(), item.getProperties())));
        }
        recNode.set("_links", (JsonNode)this.getItemLinks((Identifiable)item, requestUrl, suffixUniqueId));
        return recNode;
    }
}

