/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.config.db;

import de.uniba.minf.registry.model.entity.Entity;
import eu.dariah.de.dariahsp.spring.mvc.AuthInfoHelper;
import java.time.Instant;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.mapping.event.AbstractMongoEventListener;
import org.springframework.data.mongodb.core.mapping.event.AfterSaveEvent;
import org.springframework.data.mongodb.core.mapping.event.BeforeConvertEvent;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

@Configuration
public class EntityEventListener
extends AbstractMongoEventListener<Entity> {
    @Autowired
    private AuthInfoHelper authinfoHelper;
    @Autowired
    private MongoTemplate mongoTemplate;

    public void onBeforeConvert(BeforeConvertEvent<Entity> event) {
        super.onBeforeConvert(event);
        RequestAttributes attrs = RequestContextHolder.getRequestAttributes();
        String userUniqueId = attrs != null ? this.authinfoHelper.getAuth().getUserId() : "_system";
        Entity obj = (Entity)event.getSource();
        if (obj.getEntityId() == null) {
            obj.setEntityId(UUID.randomUUID().toString());
        }
        obj.setCreationInstant(Instant.now());
        obj.setUserUniqueId(userUniqueId);
    }

    public void onAfterSave(AfterSaveEvent<Entity> event) {
        super.onAfterSave(event);
        this.mongoTemplate.updateMulti(Query.query((CriteriaDefinition)Criteria.where((String)"entityId").is((Object)((Entity)event.getSource()).getEntityId()).and("nextVersionUniqueId").isNull().and("uniqueId").ne((Object)((Entity)event.getSource()).getUniqueId())), (UpdateDefinition)Update.update((String)"nextVersionUniqueId", (Object)((Entity)event.getSource()).getUniqueId()), Entity.class);
    }
}

