package de.uniba.minf.registry.view.model;

import java.util.List;

import de.uniba.minf.registry.model.Property;
import de.uniba.minf.registry.model.definition.PropertyDefinition;
import de.uniba.minf.registry.model.vocabulary.VocabularyDefinition;
import de.uniba.minf.registry.model.vocabulary.VocabularyEntry;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class VocabularyPropertyViewItem extends SimplePropertyViewItem {
	private VocabularyDefinition vocabularyDefinition;
	private List<VocabularyEntry> vocabularyEntries;
	
	public boolean isVocabularyMatch(String value) {
		return isSet() && vocabularyEntries!=null && vocabularyEntries.stream().anyMatch(v -> v.getKey().equals(value));
	}
	
	public boolean isFreeEntry(String value) {
		return isSet() && vocabularyEntries!=null && vocabularyEntries.stream().noneMatch(v -> v.getKey().equals(value));
	}
	
	public boolean isSet() {
		return this.getProperty()!=null && this.getProperty().getValue()!=null;
	}
	
	public VocabularyPropertyViewItem(PropertyDefinition definition, Property entity) {
		super(definition, entity);
	}
	
	@Override
	public boolean isValueList() {
		return true;
	}
}
