package de.uniba.minf.registry.view.model;

import java.util.ArrayList;
import java.util.List;

import de.uniba.minf.registry.model.Property;
import de.uniba.minf.registry.model.PropertyValue;
import de.uniba.minf.registry.model.TextPropertyValue;
import de.uniba.minf.registry.model.definition.PropertyDefinition;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class SimplePropertyViewItem extends BasePropertyViewItem {
	private final Property property;
	private VocabularyPropertyViewItem langPropertyViewItem;

	public SimplePropertyViewItem(PropertyDefinition definition, Property entity) {
		super(definition);
		this.property = entity;
	}
	
	public SimplePropertyViewItem(PropertyDefinition definition, Property entity, VocabularyPropertyViewItem langPropertyViewItem) {
		super(definition);
		this.property = entity;
		this.langPropertyViewItem= langPropertyViewItem;
	}
	
	public String getValueAsText() {
		if (property==null || property.getValue()==null) {
			return null;
		}
		return property.getValue().asText();
	}
	
	@Override
	public List<PropertyValue> valuesAsList() {
		if (property!=null && property.getValue()!=null) {
			return property.valuesAsList();
		}
		List<PropertyValue> emptyValuePlaceholderList = new ArrayList<>(1);
		emptyValuePlaceholderList.add(new TextPropertyValue(""));
		return emptyValuePlaceholderList;
	}
	
	public List<String> valuesAsStringList() {
		return this.valuesAsList().stream().map(v -> v.asText()).toList();
	}
}
