package de.uniba.minf.registry.view.helper;

import lombok.AccessLevel;
import lombok.Data;
import lombok.RequiredArgsConstructor;

@Data
@RequiredArgsConstructor(access=AccessLevel.PRIVATE)
class ResolveCacheKey {
	private final String vocabulary;
	private final String query;
	
	public static ResolveCacheKey get(String vocabulary, String query) {
		return new ResolveCacheKey(vocabulary, query);
	}
	
	@Override
	public boolean equals(Object key) {
		if (!key.getClass().isAssignableFrom(ResolveCacheKey.class)) {
			return false;
		}
		ResolveCacheKey compare = ResolveCacheKey.class.cast(key);
		return this.vocabulary.equals(compare.getVocabulary()) && this.query.equals(compare.getQuery());
	}
	
	@Override
	public int hashCode() {
		int hash = 7;
	    hash = 31 * hash + (vocabulary == null ? 0 : vocabulary.hashCode());
	    hash = 31 * hash + (query == null ? 0 : query.hashCode());
	    return hash;
	}
}