package de.uniba.minf.registry.view.helper;

import java.util.ArrayList;
import java.util.List;
import de.uniba.minf.registry.model.Property;
import de.uniba.minf.registry.model.PropertyValue;
import de.uniba.minf.registry.model.definition.PropertyDefinition;
import lombok.AllArgsConstructor;
import lombok.Data;

public class PropertyPreviewHelper {
	private static PropertyPreviewHelper singleton = null;
	private PropertyPreviewHelper() {} 
	
	@Data
	@AllArgsConstructor
	public class PreviewProperty {
		private String label;
		private PropertyValue value;
	}
	
	public static PropertyPreviewHelper get() {
		if (singleton==null) {
			singleton = new PropertyPreviewHelper();
		}
		return singleton;
	} 
	
	/**
	 * Method to extract properties based on a selection of property definitions, mainly used to render a 
	 * 	view representation based on previewProperty specification
	 * 
	 * @implNote This is flat and requires recursion for a sophisticated preview property concept
	 * 
	 * @param propertyDefinitions
	 * @param properties
	 * @return
	 */
	public List<PreviewProperty> extractSubproperties(List<PropertyDefinition> propertyDefinitions, List<Property> properties) {
		List<PreviewProperty> previewProperties = new ArrayList<>();
		for (PropertyDefinition def : propertyDefinitions) {
			for (Property prop : properties) {
				if (prop.getLabel().equals(def.getName())) {
					previewProperties.add(new PreviewProperty(prop.getLabel(), prop.getValue()));
				}
			}
		}
		return previewProperties;
	}
}