package de.uniba.minf.registry.view.controller;

import java.util.Locale;
import java.util.Optional;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;

import de.uniba.minf.registry.model.vocabulary.VocabularyDefinition;
import de.uniba.minf.registry.pojo.VocabularyDefinitionPojo;
import de.uniba.minf.registry.pojo.converter.VocabularyDefinitionConverter;
import de.uniba.minf.registry.repository.VocabularyDefinitionRepository;
import de.unibamberg.minf.core.web.controller.ResourceNotFoundException;

@Controller
@RequestMapping("/vocabularyDefinitions")
public class VocabularyDefinitionViewController extends BaseViewController {
	@Autowired private VocabularyDefinitionRepository vocabularyDefinitionRepo;
	@Autowired private VocabularyDefinitionConverter vocabularyDefinitionConverter;
	
	@Autowired @Qualifier("yamlMapper") private ObjectMapper yamlMapper;
	@Autowired @Qualifier("jsonMapper") private ObjectMapper jsonMapper;
	
	public VocabularyDefinitionViewController() {
		super("vocabularyDefinitions");
	}

	@GetMapping
    public String showDatamodels(Model model, Locale locale) {
    	model.addAttribute("apiUrlPrefix", "def/vocabularies");
    	model.addAttribute("definitionType", "vocabularyDefinitions");
        return "definitions/list";
    }
	
	@GetMapping("/{definition}/")
    public String showDefinition(@PathVariable("definition") String definition, Model model, Locale locale) throws JsonProcessingException {		
    	Optional<VocabularyDefinition> d = Optional.ofNullable(vocabularyDefinitionRepo.findCurrentByName(definition));
		if (d.isEmpty()) {
    		throw new ResourceNotFoundException();
    	}
		VocabularyDefinitionPojo p = vocabularyDefinitionConverter.convertPojo(d.get());
		model.addAttribute("def", p);
		model.addAttribute("definitionType", "vocabularyDefinitions");
		model.addAttribute("jsonDatamodel", jsonMapper.writeValueAsString(d.get()));
		model.addAttribute("yamlDatamodel", yamlMapper.writeValueAsString(d.get()));
        return "definitions/definition";
    }
}