package de.uniba.minf.registry.view.controller;

import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.ModelAndView;

import jakarta.servlet.http.HttpServletRequest;

// Influences API controllers as well
//@ControllerAdvice
public class ViewExceptionHandler extends BaseViewController {
	public ViewExceptionHandler() {
		super("error");
	}

	public static final String DEFAULT_ERROR_VIEW = "error";

	  @ExceptionHandler(value = Exception.class)
	  public String defaultErrorHandler(Model model, HttpServletRequest req, Exception e) throws Exception {
	    // If the exception is annotated with @ResponseStatus rethrow it and let the framework handle it
	    // AnnotationUtils is a Spring Framework utility class.
	    if (AnnotationUtils.findAnnotation(e.getClass(), ResponseStatus.class) != null) {
	      throw e;
	    }

	    // Otherwise setup and send the user to a default error-view.
	    model.addAttribute("exception", e);
	    model.addAttribute("url", req.getRequestURL());
	    model.addAttribute("_auth", authInfoHelper.getAuth());
	    model.addAttribute("status", 500);
	    
	    
	    
	    return DEFAULT_ERROR_VIEW;
	    
	  }
	}