package de.uniba.minf.registry.view.controller;

import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import de.uniba.minf.registry.model.definition.EntityDefinition;
import de.uniba.minf.registry.model.vocabulary.VocabularyDefinition;

@Controller
@RequestMapping("/")
public class HomeController extends BaseViewController {
	public HomeController() {
		super("home");
	}

	@GetMapping(value = {"/home", "/"})
    public String showHome(Model model, Locale locale) {
    	
    	Collection<EntityDefinition> primaryDefinitions = this.getPrimaryEntityDefinitions();
    	Map<EntityDefinition, Long> primaryDefinitionCountMap = new HashMap<>();
    	for (EntityDefinition def : primaryDefinitions) {
    		primaryDefinitionCountMap.put(def, entityRepository.countByDefinition(def.getName()));
    	}
    	model.addAttribute("primaryDefinitionCountMap", primaryDefinitionCountMap);
    	
    	Collection<EntityDefinition> secondaryDefinitions = this.getSecondaryEntityDefinitions();
    	Map<EntityDefinition, Long> secondaryDefinitionCountMap = new HashMap<>();
    	for (EntityDefinition def : secondaryDefinitions) {
    		secondaryDefinitionCountMap.put(def, entityRepository.countByDefinition(def.getName()));
    	}
    	model.addAttribute("secondaryDefinitionCountMap", secondaryDefinitionCountMap);
    	
        return "home";
    }
    
    @GetMapping("/vocabularies/{definitionName}/")
    public String showVocabularyEntries(@PathVariable("definitionName") String definitionName, Model model, Locale locale) {
    	VocabularyDefinition vocabularyDefinition = vocabularyDefinitionRepository.findCurrentByName(definitionName);
    	model.addAttribute("vocabularyDefinition", vocabularyDefinition);
    	model.addAttribute("previewProperties", vocabularyDefinition.getPreviewProperties());
    	
        return "vocabularyEntries/list";
    }

}
