package de.uniba.minf.registry.view.controller;

import java.util.Locale;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import de.uniba.minf.registry.model.definition.EntityDefinition;
import de.unibamberg.minf.core.web.exception.NotFoundException;


@Controller
@RequestMapping("/entities")
public class EntitiesViewController extends BaseViewController {
		
	public EntitiesViewController() {
		super("entities");
	}
	
	@GetMapping("/{entityType}/")
    public String showEntities(@PathVariable("entityType") String entityType, Model model, Locale locale) {
    	EntityDefinition entityDefinition = entityDefinitionRepository.findCurrentByName(entityType);
    	
    	if (entityDefinition==null) {
    		throw new NotFoundException();
    	}
    	
    	model.addAttribute("messageCode", entityDefinition.getMessageCode());
    	model.addAttribute("definitionName", entityDefinition.getName());
    	model.addAttribute("apiUrlPrefix", "e/" + entityDefinition.getName());
    	model.addAttribute("previewProperties", entityDefinition.getPreviewProperties());
    	
        return "entities/list";
    }
}
