package de.uniba.minf.registry.service;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import org.javers.core.diff.Diff;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;

import am.ik.yavi.core.ConstraintViolations;
import am.ik.yavi.core.Validator;
import de.uniba.minf.registry.model.definition.EntityDefinition;
import de.uniba.minf.registry.model.entity.Entity;
import de.uniba.minf.registry.model.validation.exception.ValidationConfigurationException;
import de.uniba.minf.registry.model.vocabulary.ValidationEntityService;

public interface EntityService extends ValidationEntityService {
	public Diff getChanges(Entity e);
	
	public Optional<Entity> findById(String uniqueId, boolean loadRelations);
	public Optional<Entity> findLatestByEntityId(String uniqueId, boolean loadRelations);
	
	public void loadRelations(Entity entity);
	
	public Entity prepareEntity(String entityId, String definition, boolean copyAsTemplate, boolean changeToDraft, boolean changeToPublished);
	public Entity fillEntityFromDataArray(Entity e, JsonNode formData);

	public List<ConstraintViolations> validateEntities(EntityDefinition ed, List<Entity> entities) throws ValidationConfigurationException;
	public List<ConstraintViolations> validateEntities(EntityDefinition ed, List<Entity> entities, boolean skipCompleteness) throws ValidationConfigurationException;
	public ConstraintViolations validateEntity(EntityDefinition ed, Entity e) throws ValidationConfigurationException;
	public ConstraintViolations validateEntity(Validator<Entity> ev, Entity e) throws ValidationConfigurationException;

	public void autopopulateVocabularyData(Entity e, EntityDefinition ed);

	public List<Entity> createEntitiesByAutoquery(String definition, String query);

	public void setOrCreateRelatedEntities(Entity e, EntityDefinition ed);
	
	public Collection<Entity> findByExternalIdentifier(EntityDefinition ed, String identifier);

	public List<Entity> readEntitiesFromYaml(String input, String entityDefinition) throws JsonProcessingException, IllegalArgumentException;
	public List<Entity> readEntitiesFromJson(String input, String entityDefinition) throws JsonProcessingException, IllegalArgumentException;
	public List<Entity> readEntitiesFromURL(URL url, String entityDefinition) throws IllegalArgumentException, IOException;
	
	public Entity save(Entity e);

	public void applyValueMappings(List<Entity> entities, Map<String, String> valueMap);
	public void applyValueMappings(Entity entity, Map<String, String> valueMap);
}
