package de.uniba.minf.registry.service;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import de.uniba.minf.registry.model.definition.EntityDefinition;
import de.uniba.minf.registry.repository.EntityDefinitionRepository;
import de.uniba.minf.registry.view.helper.EntityRelationsHelper;

@Component
public class EntityDefinitionServiceImpl implements EntityDefinitionService {

	@Autowired private EntityDefinitionRepository entityDefRepo;
	@Autowired private EntityRelationsHelper entityRelationsHelper;
	
	@Override
	public EntityDefinition findCurrentByName(String name) {
		return this.findCurrentByName(name, false);
	}

	@Override
	public EntityDefinition findCurrentByName(String name, boolean appendRelations) {
		EntityDefinition ed = entityDefRepo.findCurrentByName(name);
		if (ed!=null && appendRelations) {
			entityRelationsHelper.appendRelationsPropertyDefinitionBlock(ed);
		}
		return ed;
	}	
}
