package de.uniba.minf.registry.service;

import java.util.ArrayList;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import de.uniba.minf.registry.model.definition.EntityDefinition;
import de.uniba.minf.registry.model.definition.VocabularyPropertyDefinition;
import de.uniba.minf.registry.model.entity.AutoqueryEntityLookupService;
import de.uniba.minf.registry.model.vocabulary.VocabularyEntry;
import de.uniba.minf.registry.model.vocabulary.VocabularyLookupException;
import de.uniba.minf.registry.model.vocabulary.VocabularyLookupService;
import de.uniba.minf.registry.repository.EntityDefinitionRepository;

@Component
public class AutoqueryEntityLookupServiceImpl implements AutoqueryEntityLookupService {

	@Autowired private VocabularyLookupService vocabularyLookupService;
	@Autowired private EntityDefinitionRepository entityDefinitionRepo;
	
	
	@Override
	public boolean entityDefinitionAvailable(String definition) throws VocabularyLookupException {
		EntityDefinition ed = entityDefinitionRepo.findCurrentByName(definition);
		List<VocabularyPropertyDefinition> autoqueryProperties = ed.getAutoqueryProperties();
		
		return !autoqueryProperties.isEmpty();
	}
	
	@Override
	public boolean canResolveId(String definition, String id) throws VocabularyLookupException {
		EntityDefinition ed = entityDefinitionRepo.findCurrentByName(definition);
		if (ed!=null) {
			List<VocabularyPropertyDefinition> autoqueryProperties = ed.getAutoqueryProperties();
			if (autoqueryProperties!=null && !autoqueryProperties.isEmpty()) {
				for (VocabularyPropertyDefinition pd : autoqueryProperties) {
					if (vocabularyLookupService.canResolveId(pd.getVocabulary(), id)) {
						return true;
					}
				}
			}
		}
		return false;
	}
	
	@Override
	public VocabularyEntry resolve(String definition, String id) throws VocabularyLookupException {
		EntityDefinition ed = entityDefinitionRepo.findCurrentByName(definition);
		if (ed!=null) {
			List<VocabularyPropertyDefinition> autoqueryProperties = ed.getAutoqueryProperties();
			if (autoqueryProperties!=null && !autoqueryProperties.isEmpty()) {
				VocabularyEntry ve;
				for (VocabularyPropertyDefinition pd : autoqueryProperties) {
					ve = vocabularyLookupService.resolve(pd.getVocabulary(), id);
					if (ve!=null) {
						return ve;
					}
				}
			}
		}
		return null;
	}
	
	@Override
	public List<VocabularyEntry> search(String definition, String query) throws VocabularyLookupException {	
		EntityDefinition ed = entityDefinitionRepo.findCurrentByName(definition);
		List<VocabularyEntry> entries = new ArrayList<>();
		if (ed!=null) {
			List<VocabularyPropertyDefinition> autoqueryProperties = ed.getAutoqueryProperties();
			if (autoqueryProperties!=null && !autoqueryProperties.isEmpty()) {
				for (VocabularyPropertyDefinition pd : autoqueryProperties) {
					entries.addAll(vocabularyLookupService.search(pd.getVocabulary(), query));
				}
			}
		}
		return entries;
	}
	
}
