package de.uniba.minf.registry.repository;

import java.util.Optional;

import org.springframework.data.mongodb.repository.MongoRepository;
import org.springframework.data.mongodb.repository.Query;

import de.uniba.minf.registry.model.vocabulary.VocabularyEntry;

public interface VocabularyEntryRepository extends MongoRepository<VocabularyEntry, String>, VocabularyEntryRepositoryCustom {

	@Query("{ 'definitionName': ?0, 'key': ?1 }")
	public Optional<VocabularyEntry> findByDefinitionAndKey(String definition, String key);
}
