package de.uniba.minf.registry.repository;

import java.util.Optional;

import org.springframework.data.mongodb.repository.MongoRepository;
import org.springframework.data.mongodb.repository.Query;

import de.uniba.minf.registry.model.PersistedUser;

public interface UserRepository extends MongoRepository<PersistedUser, String> {
	@Query("{ 'issuer': ?0, 'username': ?1 }")
	public Optional<PersistedUser> findByIssuerAndUsername(String issuer, String username);

	@Query("{ 'username': ?0 }")
	public Optional<PersistedUser> findByUsername(String username);
}
