package de.uniba.minf.registry.repository;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import de.uniba.minf.registry.model.UserGroup;

public class UserGroupRepositoryCustomImpl implements UserGroupRepositoryCustom {

	@Autowired private MongoTemplate mongoTemplate;
	
	@Override
	public List<UserGroup> findByUserUniqueId(String userId) {
		Criteria criteria = new Criteria();
		criteria.orOperator(
				Criteria.where("ownerUniqueId").is(userId),
				Criteria.where("userGroupAssignments.userUniqueId").is(userId)
				);				
		return mongoTemplate.find(new Query(criteria), UserGroup.class);	
	}

	@Override
	public List<UserGroup> findUnassignedByUsername(String username) {
		Criteria criteria = Criteria
				.where("userGroupAssignments.username").is(username)
				.and("userGroupAssignments.userUniqueId").isNull();
		return mongoTemplate.find(new Query(criteria), UserGroup.class);	
	}

}
