package de.uniba.minf.registry.repository;

import java.util.Collection;
import java.util.Optional;

import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;

import de.uniba.minf.registry.model.entity.Entity;

public interface EntityRepositoryCustom {
	public Optional<Entity> findLatestByEntityId(String entityId);
	public Optional<Entity> findEarliestByEntityId(String entityId);
	public long countVersionsByEntityId(String entityId);
	public Collection<Entity> findAllLatest();
	public Collection<Entity> findLatestByDefinition(String definition);
	public Collection<Entity> findLatestByCriteria(CriteriaDefinition criteria);
	public Collection<Entity> findLatestByDefinitionAndQuery(String name, String query);
	public long countByDefinition(String definition);
	public String findDefinitionNameById(String uniqueId);
	public boolean getIsLatest(String uniqueId);
	public long countByImportId(String uniqueId);
	public Collection<Entity> findByImportId(String importId);
	public long removeImportIdByImportId(String importId);
	public long countLatestByCriteria(Criteria criteria);
}
