package de.uniba.minf.registry.repository;

import java.util.Collection;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;

import de.uniba.minf.registry.model.entity.EntityRelation;

public class EntityRelationRepositoryCustomImpl implements EntityRelationRepositoryCustom {

	@Autowired private MongoTemplate mongoTemplate;
	
	@Override
	public Collection<EntityRelation> findAllByEntityUniqueId(String uniqueId) {
		final Query query = Query.query(new Criteria().orOperator(
				Criteria.where("toUniqueId").is(uniqueId), 
				Criteria.where("fromUniqueId").is(uniqueId))
				);
		
		return mongoTemplate.find(query, EntityRelation.class);
	}

}
