package de.uniba.minf.registry.repository;

import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;

import de.uniba.minf.registry.model.definition.EntityDefinition;

public class EntityDefinitionRepositoryCustomImpl implements EntityDefinitionRepositoryCustom {

	@Autowired private MongoTemplate mongoTemplate;
	
	@Override
	public EntityDefinition findCurrentByName(String name) {
		final Query query = new Query();
		query.addCriteria(Criteria.where("name").is(name));
		query.with(Sort.by(Sort.Direction.DESC, "creationInstant"));
		
		return mongoTemplate.findOne(query, EntityDefinition.class);		
	}

	@Override
	public List<String> findAllDefinitionNames() {
		return mongoTemplate.findDistinct("name", EntityDefinition.class, String.class);
	}
	
	@Override
	public Collection<EntityDefinition> findAllLatest() {
		return findLatestByCriteria(null);
	}
	
	@Override
	public Collection<EntityDefinition> findLatestByCriteria(CriteriaDefinition criteria) {
		final Query query = new Query();
		if (criteria!=null) {
			query.addCriteria(criteria);
		}
		query.addCriteria(Criteria.where("nextVersionUniqueId").isNull());
		return mongoTemplate.find(query, EntityDefinition.class);
	}

	@Override
	public List<String> findAllDefinitionNames(boolean includeSystem) {
		if (includeSystem) {
			return findAllDefinitionNames();
		}
		return mongoTemplate.findDistinct(Query.query(Criteria.where("system").is(false)), "name", EntityDefinition.class, String.class);
	}
}