package de.uniba.minf.registry.repository;

import java.util.List;

import org.springframework.context.annotation.Primary;
import org.springframework.data.mongodb.repository.DeleteQuery;
import org.springframework.data.mongodb.repository.MongoRepository;
import org.springframework.data.mongodb.repository.Query;

import de.uniba.minf.registry.model.definition.EntityDefinition;

@Primary
public interface EntityDefinitionRepository extends MongoRepository<EntityDefinition, String>, EntityDefinitionRepositoryCustom {
	
	@Query("{ 'name': ?0 }")
	public List<EntityDefinition> findByName(String name);

	@DeleteQuery("{ 'name': ?0 }")
	public void deleteByName(String name);
}