package de.uniba.minf.registry.profiles;

import lombok.extern.slf4j.Slf4j;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;

import org.springframework.beans.factory.annotation.Autowired;

import de.uniba.minf.registry.model.PersistedUser;
import de.uniba.minf.registry.model.UserGroup;
import de.uniba.minf.registry.model.UserGroupAssignment;
import de.uniba.minf.registry.repository.UserGroupRepository;
import de.uniba.minf.registry.repository.UserRepository;
import eu.dariah.de.dariahsp.ProfileActionHandler;
import eu.dariah.de.dariahsp.model.ExtendedUserProfile;

@Slf4j
public class UserProfileActionHandler implements ProfileActionHandler {
				
	@Autowired private UserRepository userRepo;
	
	@Autowired private UserGroupRepository userGroupRepo;
	
	
	@Override
	public void handleLogin(ExtendedUserProfile profile) {
		Optional<PersistedUser> optU = userRepo.findByIssuerAndUsername(profile.getIssuerId(), profile.getUsername());
		PersistedUser u;
		boolean newUser = false;
		
		if (optU.isPresent()) {
			u = optU.get();
			profile.fillUser(u);
		} else {
			u = new PersistedUser(profile); 
			newUser = true;			
		} 
		u.setLastLogin(LocalDateTime.now());
		userRepo.save(u);
		
		if (newUser) {
			List<UserGroup> groups = userGroupRepo.findUnassignedByUsername(u.getUsername());
			for (UserGroup g : groups) {
				for (UserGroupAssignment ga : g.getUserGroupAssignments()) {
					if (ga.getUsername().equals(u.getUsername()) && ga.getUserUniqueId()==null) {
						ga.setUserUniqueId(u.getUniqueId());
					}
				}
				userGroupRepo.save(g);
				log.info("User group [{}] updated pending user assignment to uniqueId {}", g.getUniqueId(), u.getUniqueId());
			}
		}
		
		
		profile.setId(u.getUniqueId());
		profile.setUniqueId(u.getUniqueId());
		
		log.debug("User has logged in: {}=>{}", profile.getId(), u.getUniqueId());
	}

	@Override
	public void handleLogout(ExtendedUserProfile profile) {		
		log.debug("User has logged out: {}", profile.getId());
	}
}
