package de.uniba.minf.registry.pojo.converter.base;

import java.util.Collection;
import java.util.Optional;

import org.springframework.beans.factory.annotation.Autowired;

import de.uniba.minf.registry.model.PersistedUser;
import de.uniba.minf.registry.model.definition.BaseDefinition;
import de.uniba.minf.registry.model.definition.HierarchicalPropertyDefinition;
import de.uniba.minf.registry.model.definition.PropertyDefinition;
import de.uniba.minf.registry.pojo.base.BaseDefinitionPojo;
import de.uniba.minf.registry.repository.UserRepository;

public abstract class BaseDefinitionConverter<T extends BaseDefinition, P extends BaseDefinitionPojo> extends BaseConverter<T, P> {
	@Autowired private UserRepository userRepo;
		
	@Override
	public P convertPojo(T d) {
		P p = this.createPojo();
		p.setUniqueId(d.getUniqueId());
		p.setName(d.getName());
		p.setLabel(d.getName());
		p.setVersion(d.getVersion());
		p.setSystem(d.isSystem());
		p.setLatest(d.getNextVersionUniqueId()==null);
		p.setCreationInstant(d.getCreationInstant());	
		p.setUserId(d.getUserUniqueId());
		p.setRemote(d.isRemote());
		if (d.getUserUniqueId()!=null) {
			Optional<PersistedUser> u = userRepo.findById(d.getUserUniqueId());
			if (u.isPresent()) {
				p.setUsername(u.get().getUsername());
			}
		}
		p.setFieldCount(this.countProperties(d));
		return p;
	}
	
	protected abstract P createPojo();
	
	private int countProperties(T ed) {
		return this.countProperties(ed.getAllProperties());
	}
	
	private int countProperties(Collection<PropertyDefinition> pds) {
		int count = 0;
		for (PropertyDefinition pd : pds) {
			count++;
			if (pd.isHierarchical()) {
				count += countProperties(HierarchicalPropertyDefinition.class.cast(pd).getProperties());
			}
		}
		return count;
	}
}
