package de.uniba.minf.registry.pojo.converter.base;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;

public abstract class BaseConverter<T1, T2> {

	public Collection<T2> convertPojos(Collection<T1> model) {
		if (model==null) {
			return new ArrayList<>(0);
		}
		return model.stream().map(this::convertPojo).toList();
	}
	
	public Optional<T2> convertPojo(Optional<T1> model) {
		if (model==null || model.isEmpty()) {
			return Optional.empty();
		}
		return Optional.of(this.convertPojo(model.get()));
	}
	
	public abstract T2 convertPojo(T1 model);
}
