package de.uniba.minf.registry.pojo.converter;

import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import de.uniba.minf.registry.model.PersistedUser;
import de.uniba.minf.registry.model.UserGroup;
import de.uniba.minf.registry.model.UserGroupAssignment;
import de.uniba.minf.registry.pojo.UserGroupAssignmentPojo;
import de.uniba.minf.registry.pojo.converter.base.BaseConverter;
import de.uniba.minf.registry.repository.UserRepository;

@Component
public class UserGroupAssignmentConverter extends BaseConverter<UserGroup, List<UserGroupAssignmentPojo>> {

	@Autowired private UserRepository userRepository;
	
	@Override
	public List<UserGroupAssignmentPojo> convertPojo(UserGroup group) {
		List<UserGroupAssignmentPojo> assignments = new ArrayList<>();
		
		UserGroupAssignmentPojo ownerAssignment = new UserGroupAssignmentPojo();
		ownerAssignment.setName(group.getName());
		ownerAssignment.setUniqueId(group.getUniqueId());
		ownerAssignment.setUserUniqueId(group.getOwnerUniqueId());
		ownerAssignment.setUsername(userRepository.findById(group.getOwnerUniqueId()).orElse(new PersistedUser()).getUsername());
		ownerAssignment.setOwner(true);
		ownerAssignment.setWriteAccess(true);
		assignments.add(ownerAssignment);
		
		if (group.getUserGroupAssignments()!=null) {
			for (UserGroupAssignment ga : group.getUserGroupAssignments()) {
				assignments.add(this.convertUserGroupAssignment(group, ga));
			}
		}
		return assignments;
	}
	
	private UserGroupAssignmentPojo convertUserGroupAssignment(UserGroup group, UserGroupAssignment ga) {
		UserGroupAssignmentPojo uga = new UserGroupAssignmentPojo();
		uga.setName(group.getName());
		uga.setAssignmentUniqueId(uga.getAssignmentUniqueId());
		uga.setUniqueId(group.getUniqueId());
		uga.setAssignmentUniqueId(ga.getUniqueId());
		if (ga.getUserUniqueId()!=null) {
			uga.setUserUniqueId(ga.getUserUniqueId());
			uga.setUsername(userRepository.findById(ga.getUserUniqueId()).orElse(new PersistedUser()).getUsername());
		} else {
			uga.setUsername(ga.getUsername());
		}
		
		uga.setExpiration(ga.getExpiration());
		uga.setExpirationString(ga.getExpiration()==null ? null : DateTimeFormatter.ISO_DATE.withZone(ZoneId.of("UTC")).format(ga.getExpiration()));
		uga.setWriteAccess(ga.isWriteAccess());
		return uga;
	}

}
