package de.uniba.minf.registry.pojo.converter;

import org.springframework.stereotype.Component;

import de.uniba.minf.registry.model.PersistedUser;
import de.uniba.minf.registry.pojo.UserPojo;
import de.uniba.minf.registry.pojo.converter.base.BaseConverter;

@Component
public class UserConverter extends BaseConverter<PersistedUser, UserPojo> {
	
	@Override
	public UserPojo convertPojo(PersistedUser user) {
		UserPojo p = new UserPojo();
		p.setUniqueId(user.getUniqueId());
		p.setIssuer(user.getIssuer());
		p.setLanguage(user.getLanguage());
		p.setUsername(user.getUsername());		
		return p;
	}
}
