package de.uniba.minf.registry.pojo.converter;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import de.uniba.minf.registry.model.definition.EntityDefinition;
import de.uniba.minf.registry.pojo.EntityDefinitionPojo;
import de.uniba.minf.registry.pojo.converter.base.BaseDefinitionConverter;
import de.uniba.minf.registry.repository.EntityRepository;

@Component
public class EntityDefinitionConverter extends BaseDefinitionConverter<EntityDefinition, EntityDefinitionPojo> {
	@Autowired private EntityRepository entityRepo;

	@Override
	public EntityDefinitionPojo convertPojo(EntityDefinition ed) {
		EntityDefinitionPojo p = super.convertPojo(ed);
		p.setEntryCount(entityRepo.countByDefinition(ed.getName()));
		
		return p;
	}
	
	@Override
	protected EntityDefinitionPojo createPojo() {
		return new EntityDefinitionPojo();
	}
}
