package de.uniba.minf.registry.pojo;

import java.time.Instant;

import de.uniba.minf.core.rest.model.Identifiable;
import lombok.Data;

@Data
public class EntityPojo implements Identifiable {
	private static final long serialVersionUID = -3536534997477585943L;
	
	private String uniqueId;	
	private String entityId;
	private String nextVersionUniqueId;
	
	private boolean valid;
	private boolean readOnly;
	private boolean draft;
	private boolean template;
	private boolean hasProperties;
	
	private String definitionName;
	private long definitionVersion;
		
	private Instant creationInstant;
	private String userId;
	private String username;
	
	private String importId;
	
	public boolean isPublished() { return !this.draft; }
	public boolean isLatest() { return this.nextVersionUniqueId==null; }
}
