package de.uniba.minf.registry.model;

import java.io.Serializable;
import java.time.Instant;

import lombok.Data;

@Data
public class UserGroupAssignment implements Serializable {
	private static final long serialVersionUID = 758637404602043453L;
	
	private String uniqueId;
	private String userUniqueId;
	private String username;
	private boolean writeAccess;
	private Instant expiration;
	
	public boolean isPending() {
		return userUniqueId==null;
	}
	
	public boolean isExpiring() {
		return expiration!=null;
	}
	
	public boolean isExpired() {
		return expiration!=null && expiration.isBefore(Instant.now());
	}
}