package de.uniba.minf.registry.model;

import java.time.Instant;

import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.data.mongodb.core.mapping.Document;

import de.uniba.minf.core.rest.model.Identifiable;
import eu.dariah.de.dariahsp.model.AccessToken;
import jakarta.validation.constraints.NotNull;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

@Data
@Document
@EqualsAndHashCode(callSuper=true)
@ToString(callSuper = true)
public class RegistryAccessToken extends AccessToken implements Identifiable {

	private static final long serialVersionUID = -297453952968739067L;

	@Id
	private String id;
	
	@NotNull
	@Indexed
	private String userId;
	
	private Instant creationInstant;
}
