package de.uniba.minf.registry.model;

import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

import de.uniba.minf.core.rest.model.Identifiable;
import eu.dariah.de.dariahsp.model.ExtendedUserProfile;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

@Data
@Document
@EqualsAndHashCode(callSuper=true)
@ToString(callSuper = true)
@NoArgsConstructor
public class PersistedUser extends eu.dariah.de.dariahsp.model.User implements Identifiable {
	private static final long serialVersionUID = -7470824585266674170L;
		
	@Id
	private String uniqueId;
	
	public PersistedUser(ExtendedUserProfile profile) {
		if (profile!=null) {
			profile.fillUser(this);
			profile.setUniqueId(this.getUniqueId());
		}
	}
}
