package de.uniba.minf.registry.controller.user;

import java.util.Optional;

import org.springframework.beans.factory.annotation.Autowired;

import de.uniba.minf.core.rest.controller.BaseRestController;
import de.uniba.minf.core.rest.exception.ApiInsufficientPermissionsException;
import de.uniba.minf.core.rest.exception.ApiItemNotFoundException;
import de.uniba.minf.core.rest.model.Identifiable;
import de.uniba.minf.registry.model.PersistedUser;
import de.uniba.minf.registry.repository.UserRepository;
import eu.dariah.de.dariahsp.spring.mvc.AuthInfoHelper;
import eu.dariah.de.dariahsp.spring.mvc.model.AuthPojo;

public abstract class BaseUserRestController<T extends Identifiable> extends BaseRestController<T> {
	
	@Autowired protected UserRepository userRepo;
	@Autowired protected AuthInfoHelper authInfoHelper;
	
	protected BaseUserRestController(String relativeBase) {
		super(relativeBase);
	}
	
	protected PersistedUser checkCanAccessUser(AuthPojo authPojo, String reqUniqueId) throws ApiItemNotFoundException, ApiInsufficientPermissionsException {
		if (reqUniqueId==null) {
			throw new ApiItemNotFoundException(reqUniqueId, "user");
		}
		if (authPojo.getUserId()==null || authPojo.getLevel()<100 && !authPojo.getUserId().equals(reqUniqueId)) {
			throw new ApiInsufficientPermissionsException();
		}
		Optional<PersistedUser> reqUser = userRepo.findById(reqUniqueId);
		if (!reqUser.isPresent()) {
			throw new ApiItemNotFoundException(reqUniqueId, "user");
		}
		return reqUser.get();
	}
}
