package de.uniba.minf.registry.config.db;

import java.time.Instant;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.mongodb.core.mapping.event.AbstractMongoEventListener;
import org.springframework.data.mongodb.core.mapping.event.BeforeConvertEvent;

import de.uniba.minf.registry.model.vocabulary.VocabularyEntry;
import eu.dariah.de.dariahsp.spring.mvc.AuthInfoHelper;

@Configuration
public class VocabularyEntryEventListener extends AbstractMongoEventListener<VocabularyEntry> {
	
	@Autowired private AuthInfoHelper authinfoHelper;
	
	@Override
	public void onBeforeConvert(BeforeConvertEvent<VocabularyEntry> event) {
		super.onBeforeConvert(event);
		String userUniqueId = authinfoHelper.getAuth().getUserId();		
		VocabularyEntry obj = event.getSource();
		obj.setCreationInstant(Instant.now());
		obj.setUserUniqueId(userUniqueId);
		obj.setScore(0);
	}
}
