package de.uniba.minf.registry.config.db;

import java.time.Instant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.mongodb.core.mapping.event.AbstractMongoEventListener;
import org.springframework.data.mongodb.core.mapping.event.BeforeConvertEvent;

import de.uniba.minf.registry.model.entity.EntityRelation;
import eu.dariah.de.dariahsp.spring.mvc.AuthInfoHelper;

@Configuration
public class EntityRelationEventListener extends AbstractMongoEventListener<EntityRelation> {
	
	@Autowired private AuthInfoHelper authinfoHelper;
		
	@Override
	public void onBeforeConvert(BeforeConvertEvent<EntityRelation> event) {
		super.onBeforeConvert(event);
		
		String userUniqueId = authinfoHelper.getAuth().getUserId();			
		EntityRelation obj = event.getSource();
		obj.setCreationInstant(Instant.now());
		obj.setUserUniqueId(userUniqueId);
	}
}