package de.uniba.minf.registry.config;

import org.pac4j.core.config.Config;
import org.pac4j.jee.filter.CallbackFilter;
import org.pac4j.jee.filter.LogoutFilter;
import org.pac4j.jee.filter.SecurityFilter;
//import org.pac4j.jee.filter.CallbackFilter;
//import org.pac4j.jee.filter.LogoutFilter;
//import org.pac4j.jee.filter.SecurityFilter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
/*import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;

import eu.dariah.de.dariahsp.config.web.SecurityConfigurerAdapter;
import eu.dariah.de.dariahsp.config.web.DefaultFiltersConfigurerAdapter;*/

import eu.dariah.de.dariahsp.spring.config.SecurityConfig;
import eu.dariah.de.dariahsp.spring.mvc.config.AuthInfoConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;


/**
 * Web security configuration addressing protected areas and authorization patterns for this sample application
 * 
 * @author Tobias Gradl
 */
@EnableWebSecurity
@Configuration
public class WebSecurityConfig extends AuthInfoConfigurer {


    @Configuration
    public static class SamlWebSecurityConfigurationAdapter {

        @Autowired private Config config;
        
        @Bean
        public SecurityFilterChain samlFilterChain(final HttpSecurity http) throws Exception {
            final SecurityFilter filter = new SecurityFilter(config, "saml");

            http
                    .securityMatcher("/saml2/**")
                    .addFilterBefore(filter, BasicAuthenticationFilter.class)
                    .sessionManagement().sessionCreationPolicy(SessionCreationPolicy.ALWAYS);

            return http.build();
        }
    }
    
    @Configuration
    public static class LocalWebSecurityConfigurationAdapter {

        @Autowired private Config config;

        @Bean
        public SecurityFilterChain localFilterChain(final HttpSecurity http) throws Exception {
            final SecurityFilter filter = new SecurityFilter(config, "local");

            http
                    .securityMatcher("/local/**")
                    .addFilterBefore(filter, BasicAuthenticationFilter.class)
                    .sessionManagement().sessionCreationPolicy(SessionCreationPolicy.ALWAYS);

            return http.build();
        }
    }

    @Configuration
    public static class ProtectedWebSecurityConfigurationAdapter {

        @Autowired private Config config;

        @Bean
        public SecurityFilterChain protectedFilterChain(final HttpSecurity http) throws Exception {
            final SecurityFilter filter = new SecurityFilter(config);

            http
                    .securityMatcher(
                    		"/protected/**", 
                    		"/imports/**"
                    		)
                    .addFilterBefore(filter, BasicAuthenticationFilter.class)
                    .sessionManagement().sessionCreationPolicy(SessionCreationPolicy.ALWAYS);

            return http.build();
        }
    }

    @Configuration
    public static class DbaWebSecurityConfigurationAdapter {

        @Autowired private Config config;

        @Bean
        public SecurityFilterChain dbaFilterChain(final HttpSecurity http) throws Exception {

            final SecurityFilter filter = new SecurityFilter(config, "rest_systemToken,rest_localUsernamePassword");

            http
                    .securityMatcher("/dba/**")
                    .addFilterBefore(filter, BasicAuthenticationFilter.class)
                    .sessionManagement().sessionCreationPolicy(SessionCreationPolicy.NEVER);

            return http.build();
        }
    }

    @Configuration
    public static class CallbackWebSecurityConfigurationAdapter {

    	@Autowired private Config config;
        @Autowired private SecurityConfig securityConfig;

        @Bean
        public SecurityFilterChain callbackFilterChain(final HttpSecurity http) throws Exception {

            final CallbackFilter callbackFilter = new CallbackFilter(config, securityConfig.getBaseUrl());

            http
                    .securityMatcher("/callback*")
                    .addFilterBefore(callbackFilter, BasicAuthenticationFilter.class)
                    .csrf().disable();

            return http.build();
        }
    }

    @Configuration
    public static class LogoutWebSecurityConfigurationAdapter {

    	@Autowired private Config config;
        @Autowired private SecurityConfig securityConfig;

        @Bean
        public SecurityFilterChain logoutFilterChain(final HttpSecurity http) throws Exception {

            final LogoutFilter logoutFilter = new LogoutFilter(config, securityConfig.getBaseUrl());
            logoutFilter.setDestroySession(true);

            http
                    .securityMatcher("/centralLogout")
                    .addFilterBefore(logoutFilter, BasicAuthenticationFilter.class)
                    .csrf().disable();

            return http.build();
        }
    }

//    @Configuration
//    public static class ZeLastWebSecurityConfigurationAdapter {
//
//        @Autowired
//        private Config config;
//
//        @Bean
//        public SecurityFilterChain defaultFilterChain(final HttpSecurity http) throws Exception {
//
//            http
//                    .csrf().disable()
//                    .authorizeHttpRequests()
//                    .requestMatchers("/admin/**").hasRole("ADMIN")
//                    .requestMatchers("/login/**").authenticated()
//                    .anyRequest().permitAll()
//                    .and()
//                    .formLogin()
//                    .loginPage("/login")
//                    .loginProcessingUrl("/perform_login")
//                    .defaultSuccessUrl("/index.html", false)
//                    .failureUrl("/login?error=true")
//                    .and()
//                    .logout().logoutSuccessUrl("/");
//
//            return http.build();
//        }
//
//        @Bean
//        public InMemoryUserDetailsManager userDetailsService() {
//            final UserDetails user1 = User.withDefaultPasswordEncoder()
//                    .username("user")
//                    .password("user")
//                    .roles("USER")
//                    .build();
//            final UserDetails user2 = User.withDefaultPasswordEncoder()
//                    .username("admin")
//                    .password("admin")
//                    .roles("ADMIN")
//                    .build();
//            return new InMemoryUserDetailsManager(user1, user2);
//        }
//    }
//    
//	/**
//	 * Adapt this as required in a target application
//	 * 
//	 * @author Tobias Gradl
//	 */
//	/*@Configuration
//    @Order(1)
//	public class WebSecurityConfigAdapter extends SecurityConfigurerAdapter {
//	
//		public WebSecurityConfigAdapter() {
//			super(true);
//		}
//
//		@Override
//		protected List<String> getEnabledClientNames() {
//			return securityConfig.getEnabledIndirectClientNames();
//		}
//		
//		@Override
//		protected void configure(final HttpSecurity http) throws Exception {
//			 http
//	        	.requestMatchers()
//	        		.antMatchers("/protected/**", "/blocked/**")
//	        	.and()
//	        	.authorizeRequests()
//	        		.expressionHandler(this.hierarchicalExpressionHandler())
//	        		.antMatchers("/protected/authenticated").authenticated()    
//	        		.antMatchers("/protected/contributor").hasRole("CONTRIBUTOR")
//	        		.antMatchers("/protected/admin").hasRole("ADMINISTRATOR")
//	        		.antMatchers("/blocked/noaccess").denyAll();
//			 
//			 super.configure(http);
//		}
//	}*/
//	
//	/**
//	 * Make sure to include this for logout, login and callback filters 
//	 * 
//	 * @author Tobias Gradl
//	 */
//	/*@Configuration
//    @Order(2)
//    public class CallbackLoginLogoutConfigurationAdapter extends DefaultFiltersConfigurerAdapter {}*/
}
