package de.uniba.minf.registry.config;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import de.uniba.minf.registry.profiles.UserProfileActionHandler;
import eu.dariah.de.dariahsp.ProfileActionHandler;

@Configuration
@ConfigurationProperties
public class ApplicationConfig {

	/**
	 * Bean that is injected into {@link CustomizableProfileManager} to facilitate observation of login and logout actions
	 *  Implementations can provide custom implementations of the {@link ProfileActionHandler} interface e.g. to log such
	 *  actions into a database
	 *    
	 * @return SampleProfileActionHandler bean
	 */
	@Bean
	public ProfileActionHandler profileActionPostprocessor() {
		return new UserProfileActionHandler();
	}   
}
