/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.view.helper;

import de.uniba.minf.registry.model.BaseDefinedObject;
import de.uniba.minf.registry.model.Property;
import de.uniba.minf.registry.model.PropertyList;
import de.uniba.minf.registry.model.PropertyValue;
import de.uniba.minf.registry.model.TextPropertyValue;
import de.uniba.minf.registry.model.definition.BaseDefinition;
import de.uniba.minf.registry.model.definition.EntityDefinition;
import de.uniba.minf.registry.model.definition.PropertyDefinition;
import de.uniba.minf.registry.model.definition.VocabularyPropertyDefinition;
import de.uniba.minf.registry.model.entity.AutoqueryEntityLookupService;
import de.uniba.minf.registry.model.entity.Entity;
import de.uniba.minf.registry.model.vocabulary.VocabularyEntry;
import de.uniba.minf.registry.model.vocabulary.VocabularyLookupException;
import de.uniba.minf.registry.model.vocabulary.VocabularyLookupService;
import de.uniba.minf.registry.repository.EntityDefinitionRepository;
import de.uniba.minf.registry.view.helper.EntityVocabularyHelper;
import de.uniba.minf.registry.view.helper.PropertyDefinitionHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EntityVocabularyHelper {
    private static final Logger log = LoggerFactory.getLogger(EntityVocabularyHelper.class);
    @Autowired
    private VocabularyLookupService vocabularyLookupService;
    @Autowired
    private AutoqueryEntityLookupService entityLookupService;
    @Autowired
    private PropertyDefinitionHelper propertyDefinitionHelper;
    @Autowired
    private EntityDefinitionRepository entityDefRepo;

    public List<ResolvedVocabularyEntry> resolveVocabularyEntries(Entity e) {
        ArrayList<ResolvedVocabularyEntry> resolved = new ArrayList<ResolvedVocabularyEntry>();
        if (e.getProperties() == null) {
            return resolved;
        }
        if (e.getPropertyDefinitions() == null) {
            EntityDefinition ed = this.entityDefRepo.findCurrentByName(e.getDefinitionName());
            this.propertyDefinitionHelper.mergeWithDefinition((BaseDefinedObject)e, (BaseDefinition)ed, false);
        }
        this.resolveVocabularyEntries(e.getProperties(), e.getPropertyDefinitions(), resolved, null);
        return resolved;
    }

    private void resolveVocabularyEntries(List<Property> properties, List<PropertyDefinition> propertyDefinitions, List<ResolvedVocabularyEntry> resolved, String path) {
        for (PropertyDefinition pd : propertyDefinitions) {
            String subPath;
            if (pd.isSimple()) continue;
            List<Property> subProperties = properties.stream().filter(p -> p.getLabel().equals(pd.getName())).toList();
            String string = subPath = path == null ? pd.getName() : path + "." + pd.getName();
            if (pd.isVocabulary()) {
                this.resolveVocabularyEntries(subProperties, (VocabularyPropertyDefinition)VocabularyPropertyDefinition.class.cast(pd), resolved, path);
                continue;
            }
            if (!pd.isHierarchical()) continue;
            for (Property p2 : subProperties) {
                for (int i = 0; i < p2.getProperties().size(); ++i) {
                    this.resolveVocabularyEntries(((PropertyList)p2.getProperties().get(i)).getProperties(), ((PropertyList)p2.getProperties().get(i)).getPropertyDefinitions(), resolved, subPath + "[" + i + "]");
                }
            }
        }
    }

    private void resolveVocabularyEntries(List<Property> properties, VocabularyPropertyDefinition definition, List<ResolvedVocabularyEntry> resolved, String path) {
        path = path == null ? definition.getName() : "." + definition.getName();
        for (Property p : properties) {
            List values = p.valuesAsList();
            Object subpath = path;
            for (int i = 0; i < values.size(); ++i) {
                PropertyValue v = (PropertyValue)values.get(i);
                if (values.size() > 1) {
                    subpath = (String)path + "[" + i + "]";
                }
                try {
                    VocabularyEntry ve = definition.isEntity() ? this.entityLookupService.resolve(definition.getVocabulary(), v.asText()) : this.vocabularyLookupService.resolve(definition.getVocabulary(), v.asText());
                    if (ve != null) continue;
                    List veCandidates = definition.isEntity() ? this.entityLookupService.search(definition.getVocabulary(), v.asText()) : this.vocabularyLookupService.search(definition.getVocabulary(), v.asText());
                    if (veCandidates == null || veCandidates.isEmpty()) {
                        log.debug("Resolving '{}' against vocabulary '{}': No match found", (Object)v.asText(), (Object)definition.getVocabulary());
                        resolved.add(new ResolvedVocabularyEntry(this, definition.getVocabulary(), v.asText(), null, 0, (String)subpath));
                    } else if (veCandidates.size() == 1) {
                        String resolvedKey = ((VocabularyEntry)veCandidates.get(0)).getKey();
                        resolved.add(new ResolvedVocabularyEntry(this, definition.getVocabulary(), v.asText(), resolvedKey, 1, (String)subpath));
                        ((TextPropertyValue)TextPropertyValue.class.cast(v)).setValue((Serializable)((Object)resolvedKey));
                        log.debug("Resolving '{}' against vocabulary '{}': One match found => set", (Object)v.asText(), (Object)definition.getVocabulary());
                    } else if (((VocabularyEntry)veCandidates.get(0)).getScore() > 0.0 && ((VocabularyEntry)veCandidates.get(1)).getScore() > 0.0 && ((VocabularyEntry)veCandidates.get(0)).getScore() > 50.0 && ((VocabularyEntry)veCandidates.get(0)).getScore() / 3.0 > ((VocabularyEntry)veCandidates.get(1)).getScore()) {
                        log.debug("Resolving '{}' against vocabulary '{}': {} matches found => most probable chosen", new Object[]{v.asText(), definition.getVocabulary(), veCandidates.size()});
                        resolved.add(new ResolvedVocabularyEntry(this, definition.getVocabulary(), v.asText(), ((VocabularyEntry)veCandidates.get(0)).getKey(), veCandidates.size(), (String)subpath));
                        ((TextPropertyValue)TextPropertyValue.class.cast(v)).setValue((Serializable)((Object)((VocabularyEntry)veCandidates.get(0)).getKey()));
                    } else {
                        log.debug("Resolving '{}' against vocabulary '{}': {} matches found => unhandled", new Object[]{v.asText(), definition.getVocabulary(), veCandidates.size()});
                        resolved.add(new ResolvedVocabularyEntry(this, definition.getVocabulary(), v.asText(), null, veCandidates.size(), (String)subpath));
                    }
                    log.debug("{} candidates identified", (Object)(veCandidates == null ? 0 : veCandidates.size()));
                    continue;
                }
                catch (VocabularyLookupException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

