/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.view.controller;

import de.uniba.minf.registry.model.definition.EntityDefinition;
import de.uniba.minf.registry.model.vocabulary.VocabularyDefinition;
import de.uniba.minf.registry.repository.EntityRepository;
import de.uniba.minf.registry.repository.UserRepository;
import de.uniba.minf.registry.repository.VocabularyEntryRepository;
import de.uniba.minf.registry.service.EntityService;
import de.uniba.minf.registry.view.controller.BaseViewController;
import de.uniba.minf.registry.view.helper.PropertyViewItemCombiner;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.format.datetime.DateFormatter;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/"})
public class HomeController
extends BaseViewController {
    private static final Logger log = LoggerFactory.getLogger(HomeController.class);
    @Autowired
    private DateFormatter dateFormat;
    @Autowired
    private EntityRepository entityRepository;
    @Autowired
    private EntityService entityService;
    @Autowired
    private VocabularyEntryRepository vocabularyEntryRepository;
    @Autowired
    private PropertyViewItemCombiner propertyViewItemCombiner;
    @Autowired
    private UserRepository userRepository;

    public HomeController() {
        super("home");
    }

    @GetMapping(value={"/home", "/"})
    public String showHome(Model model, Locale locale) {
        model.addAttribute("serverTime", (Object)this.dateFormat.print(new Date(), locale));
        Collection entityDefinitions = this.entityDefinitionRepository.findAllLatest();
        HashMap<String, Long> entityDefinitionCountMap = new HashMap<String, Long>();
        for (EntityDefinition def : entityDefinitions) {
            entityDefinitionCountMap.put(def.getName(), this.entityRepository.countByDefinition(def.getName()));
        }
        model.addAttribute("entityDefinitionCountMap", entityDefinitionCountMap);
        List vocabularyDefinitionNames = this.vocabularyDefinitionRepository.findAllDefinitionNames();
        HashMap<String, Long> vocabularyDefinitionCountMap = new HashMap<String, Long>();
        for (String defName : vocabularyDefinitionNames) {
            vocabularyDefinitionCountMap.put(defName, this.vocabularyEntryRepository.countByDefinition(defName));
        }
        model.addAttribute("vocabularyDefinitionCountMap", vocabularyDefinitionCountMap);
        return "home";
    }

    @GetMapping(value={"/vocabularies/{definitionName}/"})
    public String showVocabularyEntries(@PathVariable String definitionName, Model model, Locale locale) {
        model.addAttribute("serverTime", (Object)this.dateFormat.print(new Date(), locale));
        VocabularyDefinition vocabularyDefinition = this.vocabularyDefinitionRepository.findCurrentByName(definitionName);
        model.addAttribute("vocabularyDefinition", (Object)vocabularyDefinition);
        return "vocabularyEntries/list";
    }

    @GetMapping(value={"/bootstrap"})
    public String showBootstrap(Model model, Locale locale) {
        model.addAttribute("serverTime", (Object)this.dateFormat.print(new Date(), locale));
        return "bootstrap";
    }
}

