/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.view.controller;

import de.uniba.minf.registry.model.definition.EntityDefinition;
import de.uniba.minf.registry.model.vocabulary.VocabularyDefinition;
import de.uniba.minf.registry.repository.EntityDefinitionRepository;
import de.uniba.minf.registry.repository.EntityRepository;
import de.uniba.minf.registry.repository.VocabularyDefinitionRepository;
import de.uniba.minf.registry.service.EntityDefinitionService;
import de.unibamberg.minf.core.web.controller.BaseTranslationController;
import de.unibamberg.minf.core.web.exception.NotFoundException;
import eu.dariah.de.dariahsp.spring.mvc.AuthInfoHelper;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Collection;
import java.util.Locale;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;

public class BaseViewController
extends BaseTranslationController {
    @Autowired
    protected EntityDefinitionService entityDefinitionService;
    @Autowired
    protected EntityDefinitionRepository entityDefinitionRepository;
    @Autowired
    protected EntityRepository entityRepository;
    @Autowired
    protected VocabularyDefinitionRepository vocabularyDefinitionRepository;
    @Autowired
    protected AuthInfoHelper authInfoHelper;
    @Value(value="${baseUrl}")
    protected String baseUrl;

    @ModelAttribute(value="entityDefinitions")
    public Collection<EntityDefinition> getEntityDefinitions() {
        return this.entityDefinitionRepository.findAllLatest().stream().filter(ed -> !ed.isSystem()).toList();
    }

    @ModelAttribute(value="_draftCount")
    public long getDraftCount() {
        return this.entityRepository.countLatestByCriteria(Criteria.where((String)"draft").is((Object)true).and("userUniqueId").is((Object)this.authInfoHelper.getUserId()));
    }

    @ModelAttribute(value="systemEntityDefinitions")
    public Collection<EntityDefinition> getSystemEntityDefinitions() {
        return this.entityDefinitionRepository.findAllLatest().stream().filter(ed -> ed.isSystem()).toList();
    }

    @ModelAttribute(value="vocabularyDefinitions")
    public Collection<VocabularyDefinition> getVocabularyDefinitions() {
        return this.vocabularyDefinitionRepository.findAllLatest().stream().filter(ed -> !ed.isSystem()).toList();
    }

    @ModelAttribute(value="systemVocabularyDefinitions")
    public Collection<VocabularyDefinition> getSystemVocabularyDefinitions() {
        return this.vocabularyDefinitionRepository.findAllLatest().stream().filter(ed -> ed.isSystem()).toList();
    }

    public BaseViewController(String mainNavId) {
        super(mainNavId);
    }

    @ExceptionHandler(value={NotFoundException.class})
    public String handleRuntimeException(Model model, HttpServletResponse resp, HttpServletRequest req, NotFoundException ex, Locale locale) {
        resp.setStatus(ex.getStatus().value());
        String message = ex.getMessage();
        model.addAttribute("status", (Object)ex.getStatus());
        model.addAttribute("message", (Object)message);
        model.addAttribute("_auth", (Object)this.authInfoHelper.getAuth());
        return "error";
    }
}

