/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.service;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.uniba.minf.registry.model.vocabulary.VocabularyDefinition;
import de.uniba.minf.registry.model.vocabulary.VocabularyEntry;
import de.uniba.minf.registry.model.vocabulary.VocabularyLookupException;
import de.uniba.minf.registry.model.vocabulary.VocabularyLookupService;
import de.uniba.minf.registry.repository.VocabularyDefinitionRepository;
import de.uniba.minf.registry.repository.VocabularyEntryRepository;
import de.uniba.minf.registry.service.VocabularyLookupServiceImpl;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
public class VocabularyLookupServiceImpl
implements VocabularyLookupService,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(VocabularyLookupServiceImpl.class);
    private static final int HTTP_TIMEOUT = 5000;
    @Autowired
    private VocabularyDefinitionRepository vocabularyDefinitionRepository;
    @Autowired
    private VocabularyEntryRepository vocabularyEntryRepository;
    @Autowired
    @Qualifier(value="yamlMapper")
    private ObjectMapper yamlMapper;
    @Autowired
    @Qualifier(value="jsonMapper")
    private ObjectMapper jsonMapper;
    @Value(value="#{${debug}==true || ${debugging.onlinelookups}==true}")
    private boolean debugLookups;

    public void afterPropertiesSet() throws Exception {
        if (this.debugLookups) {
            log.debug("Debugging mode for vocabulary lookups configured");
        }
    }

    public boolean vocabularyAvailable(String vocabulary) throws VocabularyLookupException {
        VocabularyDefinition definition;
        try {
            definition = this.getAndCheckVocabulary(vocabulary);
        }
        catch (VocabularyLookupException ex) {
            return false;
        }
        RestTemplate restTemplate = new RestTemplate(this.getClientHttpRequestFactory());
        Set optionsForAllow = restTemplate.optionsForAllow(definition.getEndpointUrl(), new Object[0]);
        return optionsForAllow.contains(HttpMethod.valueOf((String)(definition.getEndpointMethod() == null ? "GET" : definition.getEndpointMethod())));
    }

    public boolean canResolveId(String vocabulary, String id) throws VocabularyLookupException {
        VocabularyDefinition definition;
        try {
            definition = this.getAndCheckVocabulary(vocabulary);
        }
        catch (VocabularyLookupException ex) {
            return false;
        }
        if (this.find(vocabulary, id).isPresent()) {
            return true;
        }
        if (definition.isRemote()) {
            return !this.fetch(vocabulary, definition.getEndpointUrl(), definition.getEndpointMethod(), id, null).isEmpty();
        }
        return false;
    }

    public VocabularyEntry resolve(String vocabulary, String id) throws VocabularyLookupException {
        VocabularyDefinition definition;
        try {
            definition = this.getAndCheckVocabulary(vocabulary);
        }
        catch (VocabularyLookupException ex) {
            return null;
        }
        Optional ve = this.find(vocabulary, id);
        if (ve.isPresent()) {
            return (VocabularyEntry)ve.get();
        }
        if (definition.isRemote()) {
            List veList = this.fetch(vocabulary, definition.getEndpointUrl(), definition.getEndpointMethod(), id, null);
            if (veList.isEmpty()) {
                return null;
            }
            return (VocabularyEntry)veList.get(0);
        }
        return null;
    }

    public List<VocabularyEntry> search(String vocabulary, String query) throws VocabularyLookupException {
        List<VocabularyEntry> result;
        VocabularyDefinition definition;
        try {
            definition = this.getAndCheckVocabulary(vocabulary);
        }
        catch (VocabularyLookupException ex) {
            return new ArrayList<VocabularyEntry>(0);
        }
        Optional ve = this.find(vocabulary, query);
        if (ve.isPresent()) {
            result = new ArrayList<VocabularyEntry>();
            result.add((VocabularyEntry)ve.get());
        } else {
            result = definition.isRemote() ? this.fetch(vocabulary, definition.getEndpointUrl(), definition.getEndpointMethod(), query, null) : this.vocabularyEntryRepository.findByDefinitionAndQuery(vocabulary, query);
        }
        if (result.isEmpty() && definition.isRemote()) {
            result = this.fetch(vocabulary, definition.getEndpointUrl(), definition.getEndpointMethod(), null, query);
        }
        return result;
    }

    private VocabularyEntry processItem(String vocabulary, JsonNode node) throws VocabularyLookupException {
        try {
            if (node.isObject() && node.has("vocabularyEntry")) {
                VocabularyEntry ve = (VocabularyEntry)this.jsonMapper.treeToValue((TreeNode)node.get("vocabularyEntry"), VocabularyEntry.class);
                ve.setDefinitionName(vocabulary);
                if (this.find(vocabulary, ve.getKey()).isEmpty()) {
                    log.debug("Persisting fetched entry with key '{}' to vocabulary '{}'", (Object)vocabulary, (Object)ve.getKey());
                    this.vocabularyEntryRepository.save((Object)ve);
                }
                return ve;
            }
        }
        catch (Exception e) {
            throw new VocabularyLookupException(vocabulary, null, false, "Failed to process vocabulary endpoint response", (Throwable)e);
        }
        return null;
    }

    private Optional<VocabularyEntry> find(String vocabulary, String id) throws VocabularyLookupException {
        Optional ve = this.vocabularyEntryRepository.findByDefinitionAndKey(vocabulary, id);
        if (this.debugLookups) {
            log.debug("Local query on vocabulary '{}' with id '{}' returned {} entry", new Object[]{vocabulary, id, ve.isEmpty() ? "NO" : "matching"});
        }
        return this.vocabularyEntryRepository.findByDefinitionAndKey(vocabulary, id);
    }

    private List<VocabularyEntry> fetch(String vocabulary, String url, String method, String id, String query) throws VocabularyLookupException {
        RestTemplate restTemplate = new RestTemplate(this.getClientHttpRequestFactory());
        try {
            HttpMethod httpMethod = HttpMethod.valueOf((String)(method == null ? "GET" : method));
            HttpEntity request = new HttpEntity((Object)new Query(this, query, id));
            ResponseEntity response = restTemplate.exchange(url, httpMethod, request, String.class, new Object[0]);
            ArrayList<VocabularyEntry> result = new ArrayList<VocabularyEntry>();
            JsonNode root = this.jsonMapper.readTree((String)response.getBody());
            JsonNode items = root.get("response").get("items");
            VocabularyEntry ve = this.processItem(vocabulary, items);
            if (ve != null && result.stream().noneMatch(r -> r.getKey().equals(ve.getKey()))) {
                result.add(ve);
            } else if (items.isArray()) {
                for (JsonNode item : items) {
                    VocabularyEntry veArr = this.processItem(vocabulary, item);
                    if (veArr == null || !result.stream().noneMatch(r -> r.getKey().equals(veArr.getKey()))) continue;
                    result.add(veArr);
                }
            }
            if (this.debugLookups) {
                log.debug("Remote query on vocabulary '{}' with {}{} returned {} entry", new Object[]{vocabulary, id != null ? "id '" + id + "'" : "", query != null ? "query '" + query + "'" : "", result.isEmpty() ? "NO" : result.size() + " matching"});
            }
            return result;
        }
        catch (VocabularyLookupException e) {
            throw e;
        }
        catch (Exception e) {
            throw new VocabularyLookupException(vocabulary, String.format("id: %s; query: %s", id, query), true, "Failed to fetch vocabulary entries", (Throwable)e);
        }
    }

    private VocabularyDefinition getAndCheckVocabulary(String vocabulary) throws VocabularyLookupException {
        VocabularyDefinition definition = this.vocabularyDefinitionRepository.findCurrentByName(vocabulary);
        if (definition == null) {
            throw new VocabularyLookupException(vocabulary, null, false, "Vocabulary definition not available");
        }
        if (definition.isRemote()) {
            if (definition.getEndpointUrl() == null) {
                throw new VocabularyLookupException(vocabulary, null, false, "Endpoint for vocabulary not specified");
            }
            try {
                new URL(definition.getEndpointUrl()).toURI();
                return definition;
            }
            catch (Exception e) {
                throw new VocabularyLookupException(vocabulary, null, false, "Endpoint URL invalid for vocabulary", (Throwable)e);
            }
        }
        return definition;
    }

    private ClientHttpRequestFactory getClientHttpRequestFactory() {
        HttpComponentsClientHttpRequestFactory clientHttpRequestFactory = new HttpComponentsClientHttpRequestFactory();
        clientHttpRequestFactory.setConnectTimeout(5000);
        return clientHttpRequestFactory;
    }
}

