/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.service;

import de.uniba.minf.registry.model.Import;
import de.uniba.minf.registry.model.definition.EntityDefinition;
import de.uniba.minf.registry.model.entity.Entity;
import de.uniba.minf.registry.repository.EntityRepository;
import de.uniba.minf.registry.repository.ImportRepository;
import de.uniba.minf.registry.service.EntityService;
import de.uniba.minf.registry.service.ImportService;
import eu.dariah.de.dariahsp.spring.mvc.AuthInfoHelper;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ImportServiceImpl
implements ImportService {
    private static final Logger log = LoggerFactory.getLogger(ImportServiceImpl.class);
    @Autowired
    private EntityService entityService;
    @Autowired
    private EntityRepository entityRepo;
    @Autowired
    private ImportRepository importRepo;
    @Autowired
    private AuthInfoHelper authinfoHelper;

    public long deleteImport(String uniqueId) {
        Optional i = this.importRepo.findById((Object)uniqueId);
        if (i.isEmpty()) {
            return 0L;
        }
        return this.deleteImport((Import)i.get());
    }

    public long deleteImport(Import i) {
        long count;
        if (i.isReadOnly()) {
            Collection entities = this.entityRepo.findByImportId(i.getUniqueId());
            count = entities.size();
            this.entityRepo.deleteAll((Iterable)entities);
            log.info("Deleting read-only import, deleted {} associated entites", (Object)count);
        } else {
            count = this.entityRepo.removeImportIdByImportId(i.getUniqueId());
            log.info("Deleting modifiable import, unassociated {} entites", (Object)count);
        }
        this.importRepo.delete((Object)i);
        log.info("Deleted import: {}", (Object)i.getUniqueId());
        return count;
    }

    public Import importEntities(List<Entity> entities, List<Boolean> isDraft, EntityDefinition ed, boolean readonly, String templateId) {
        String userId = this.authinfoHelper.getAuth().getUserId();
        Import im = new Import();
        im.setReadOnly(readonly);
        im.setTemplateId(templateId);
        im.setUserUniqueId(userId);
        im.setCreationInstant(Instant.now());
        this.importRepo.save((Object)im);
        for (int i = 0; i < entities.size(); ++i) {
            entities.get(i).setUserUniqueId(userId);
            entities.get(i).setImportId(im.getUniqueId());
            entities.get(i).setReadOnly(readonly);
            entities.get(i).setDraft(isDraft.get(i).booleanValue());
            this.entityService.setOrCreateRelatedEntities(entities.get(i), ed);
            this.entityService.save(entities.get(i));
        }
        return im;
    }
}

