/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.service;

import de.uniba.minf.registry.model.definition.EntityDefinition;
import de.uniba.minf.registry.model.definition.VocabularyPropertyDefinition;
import de.uniba.minf.registry.model.entity.AutoqueryEntityLookupService;
import de.uniba.minf.registry.model.vocabulary.VocabularyEntry;
import de.uniba.minf.registry.model.vocabulary.VocabularyLookupException;
import de.uniba.minf.registry.model.vocabulary.VocabularyLookupService;
import de.uniba.minf.registry.repository.EntityDefinitionRepository;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AutoqueryEntityLookupServiceImpl
implements AutoqueryEntityLookupService {
    @Autowired
    private VocabularyLookupService vocabularyLookupService;
    @Autowired
    private EntityDefinitionRepository entityDefinitionRepo;

    public boolean entityDefinitionAvailable(String definition) throws VocabularyLookupException {
        EntityDefinition ed = this.entityDefinitionRepo.findCurrentByName(definition);
        List autoqueryProperties = ed.getAutoqueryProperties();
        return !autoqueryProperties.isEmpty();
    }

    public boolean canResolveId(String definition, String id) throws VocabularyLookupException {
        EntityDefinition ed = this.entityDefinitionRepo.findCurrentByName(definition);
        List autoqueryProperties = ed.getAutoqueryProperties();
        if (!autoqueryProperties.isEmpty()) {
            for (VocabularyPropertyDefinition pd : autoqueryProperties) {
                if (!this.vocabularyLookupService.canResolveId(pd.getVocabulary(), id)) continue;
                return true;
            }
        }
        return false;
    }

    public VocabularyEntry resolve(String definition, String id) throws VocabularyLookupException {
        EntityDefinition ed = this.entityDefinitionRepo.findCurrentByName(definition);
        List autoqueryProperties = ed.getAutoqueryProperties();
        if (!autoqueryProperties.isEmpty()) {
            for (VocabularyPropertyDefinition pd : autoqueryProperties) {
                VocabularyEntry ve = this.vocabularyLookupService.resolve(pd.getVocabulary(), id);
                if (ve == null) continue;
                return ve;
            }
        }
        return null;
    }

    public List<VocabularyEntry> search(String definition, String query) throws VocabularyLookupException {
        EntityDefinition ed = this.entityDefinitionRepo.findCurrentByName(definition);
        List autoqueryProperties = ed.getAutoqueryProperties();
        ArrayList<VocabularyEntry> entries = new ArrayList<VocabularyEntry>();
        if (!autoqueryProperties.isEmpty()) {
            for (VocabularyPropertyDefinition pd : autoqueryProperties) {
                entries.addAll(this.vocabularyLookupService.search(pd.getVocabulary(), query));
            }
        }
        return entries;
    }
}

