/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.controller.user;

import com.fasterxml.jackson.databind.JsonNode;
import de.uniba.minf.core.rest.exception.ApiInsufficientPermissionsException;
import de.uniba.minf.core.rest.exception.ApiItemNotFoundException;
import de.uniba.minf.core.rest.model.Identifiable;
import de.uniba.minf.core.rest.model.RestItemResponse;
import de.uniba.minf.core.rest.model.RestItemsResponse;
import de.uniba.minf.core.rest.model.RestResponse;
import de.uniba.minf.registry.controller.user.BaseUserRestController;
import de.uniba.minf.registry.model.PersistedUser;
import de.uniba.minf.registry.model.RegistryAccessToken;
import de.uniba.minf.registry.repository.AccessTokenRepository;
import eu.dariah.de.dariahsp.spring.mvc.model.AuthPojo;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="Access Token", description="API methods for user access tokens")
@RestController
@RequestMapping(value={"/api/v1/tokens/{userUID}"})
public class AccessTokenController
extends BaseUserRestController<RegistryAccessToken> {
    private static final Logger log = LoggerFactory.getLogger(AccessTokenController.class);
    private static final String ITEM_TYPE = "accessToken";
    @Autowired
    private AccessTokenRepository accessTokenRepo;

    public AccessTokenController() {
        super("/api/v1/tokens");
    }

    @GetMapping
    public RestItemsResponse getUserAccessTokens(@PathVariable String userUID, HttpServletRequest request, Locale locale) throws ApiInsufficientPermissionsException, ApiItemNotFoundException {
        AuthPojo authPojo = this.authInfoHelper.getAuth();
        PersistedUser user = this.checkCanAccessUser(authPojo, userUID);
        RestItemsResponse resp = new RestItemsResponse();
        List tokens = this.accessTokenRepo.findByUserId(user.getUniqueId());
        tokens.stream().forEach(t -> t.setUniqueId(null));
        resp.setSize((long)tokens.size());
        resp.setItems(this.getItems((Collection)tokens, request.getRequestURL().toString()));
        resp.setLinks((JsonNode)this.getLinks(request.getRequestURL().toString()));
        return resp;
    }

    @GetMapping(value={"/{tokenUID}"})
    public RestItemResponse getUserAccessToken(@PathVariable String userUID, @PathVariable String tokenUID, HttpServletRequest request, Locale locale) throws ApiInsufficientPermissionsException, ApiItemNotFoundException {
        RegistryAccessToken t = this.getToken(userUID, tokenUID);
        t.setUniqueId(null);
        return this.getItemResponse((Identifiable)t, request, RestResponse.ApiActions.GET);
    }

    @DeleteMapping(value={"/{tokenUID}"})
    public RestItemResponse deleteUserAccessToken(@PathVariable String userUID, @PathVariable String tokenUID, HttpServletRequest request, Locale locale) throws ApiInsufficientPermissionsException, ApiItemNotFoundException {
        RegistryAccessToken token = this.getToken(userUID, tokenUID);
        this.accessTokenRepo.deleteById((Object)token.getId());
        token.setUniqueId(null);
        return this.getItemResponse((Identifiable)token, request, RestResponse.ApiActions.DELETED);
    }

    @PostMapping(value={"/{tokenUID}"})
    public RestItemResponse updateUserAccessToken(@PathVariable String userUID, @PathVariable String tokenUID, @RequestBody RegistryAccessToken updatedToken, HttpServletRequest request, Locale locale) throws ApiInsufficientPermissionsException, ApiItemNotFoundException {
        RegistryAccessToken token = this.getToken(userUID, tokenUID);
        this.fillToken(token, updatedToken);
        this.accessTokenRepo.save((Object)token);
        token.setUniqueId(null);
        return this.getItemResponse((Identifiable)token, request, RestResponse.ApiActions.UPDATED);
    }

    @PostMapping
    public RestItemResponse saveNewUserAccessToken(@PathVariable String userUID, @RequestBody(required=false) RegistryAccessToken newToken, HttpServletRequest request, Locale locale) throws ApiInsufficientPermissionsException, ApiItemNotFoundException {
        AuthPojo authPojo = this.authInfoHelper.getAuth();
        PersistedUser user = this.checkCanAccessUser(authPojo, userUID);
        RegistryAccessToken token = new RegistryAccessToken();
        this.fillToken(token, newToken);
        token.setUserId(user.getUniqueId());
        token.setUniqueId(UUID.randomUUID().toString());
        token.setCreationInstant(Instant.now());
        this.accessTokenRepo.save((Object)token);
        return this.getItemResponse((Identifiable)token, request, RestResponse.ApiActions.CREATED);
    }

    private RegistryAccessToken getToken(String userUID, String tokenUID) throws ApiItemNotFoundException, ApiInsufficientPermissionsException {
        AuthPojo authPojo = this.authInfoHelper.getAuth();
        PersistedUser user = this.checkCanAccessUser(authPojo, userUID);
        RegistryAccessToken token = this.accessTokenRepo.findByIdAndUserId(tokenUID, user.getUniqueId());
        if (token == null) {
            throw new ApiItemNotFoundException(ITEM_TYPE, tokenUID);
        }
        return token;
    }

    private void fillToken(RegistryAccessToken saveToken, RegistryAccessToken updateToken) {
        if (updateToken != null) {
            saveToken.setAllowedAdresses(updateToken.getAllowedAdresses());
            saveToken.setExpires(updateToken.getExpires());
            saveToken.setName(updateToken.getName());
        }
        saveToken.setWriteAccess(true);
    }
}

